/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

public class MultiSelectPicklistSerializer
extends JsonSerializer<Object> {
    private static final String FACTORY_METHOD = "fromValue";

    @Override
    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        Class<?> arrayClass = value.getClass();
        Class<?> aClass = arrayClass.getComponentType();
        try {
            Method getterMethod = aClass.getMethod("value", new Class[0]);
            int length = Array.getLength(value);
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                buffer.append((String)getterMethod.invoke(Array.get(value, i), new Object[0]));
                if (i >= length - 1) continue;
                buffer.append(';');
            }
            jgen.writeString(buffer.toString());
        }
        catch (Exception e) {
            throw new JsonGenerationException(String.format("Exception writing pick list value %s of type %s: %s", value, value.getClass().getName(), e.getMessage()), e);
        }
    }
}

