/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Array;

public class StringMultiSelectPicklistConverter
implements Converter {
    @Override
    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext context) {
        try {
            int length = Array.getLength(o);
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                buffer.append((String)o);
                if (i >= length - 1) continue;
                buffer.append(';');
            }
            writer.setValue(buffer.toString());
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Exception writing pick list value %s of type %s: %s", o, o.getClass().getName(), e.getMessage()), e);
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String listValue = reader.getValue();
        Class requiredArrayType = context.getRequiredType();
        try {
            String[] value = listValue.split(";");
            int length = value.length;
            String[] resultArray = new String[length];
            for (int i = 0; i < length; ++i) {
                resultArray[i] = value[i].trim();
                Array.set(resultArray, i, value[i].trim());
            }
            return resultArray;
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Exception reading pick list value %s of type %s: %s", listValue, requiredArrayType.getName(), e.getMessage()), e);
        }
    }

    @Override
    public boolean canConvert(Class aClass) {
        Class<?> componentType = aClass.getComponentType();
        return componentType != null && String.class == componentType;
    }
}

