/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api;

import java.io.IOException;
import java.lang.reflect.Array;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.ContextualDeserializer;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;

public class StringMultiSelectPicklistDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer<Object> {
    @Override
    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String listValue = jp.getText();
        try {
            String[] value = listValue.split(";");
            int length = value.length;
            Object resultArray = Array.newInstance(String.class, length);
            for (int i = 0; i < length; ++i) {
                Array.set(resultArray, i, value[i].trim());
            }
            return resultArray;
        }
        catch (Exception e) {
            throw new JsonParseException("Exception reading multi-select pick list value", jp.getCurrentLocation(), e);
        }
    }

    @Override
    public JsonDeserializer<Object> createContextual(DeserializationConfig config, BeanProperty property) throws JsonMappingException {
        Class<?> rawClass = property.getType().getRawClass();
        Class<?> componentType = rawClass.getComponentType();
        if (componentType == null || componentType != String.class) {
            throw new JsonMappingException("Pick list String array expected for " + rawClass);
        }
        return new StringMultiSelectPicklistDeserializer();
    }
}

