/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Method;

public class PicklistEnumConverter
implements Converter {
    private static final String FACTORY_METHOD = "fromValue";

    @Override
    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext context) {
        Class<?> aClass = o.getClass();
        try {
            Method getterMethod = aClass.getMethod("value", new Class[0]);
            writer.setValue((String)getterMethod.invoke(o, new Object[0]));
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Exception writing pick list value %s of type %s: %s", o, o.getClass().getName(), e.getMessage()), e);
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String value = reader.getValue();
        Class requiredType = context.getRequiredType();
        try {
            Method factoryMethod = requiredType.getMethod(FACTORY_METHOD, String.class);
            return factoryMethod.invoke(null, value);
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Exception reading pick list value %s of type %s: %s", value, context.getRequiredType().getName(), e.getMessage()), e);
        }
    }

    @Override
    public boolean canConvert(Class aClass) {
        try {
            return Enum.class.isAssignableFrom(aClass) && aClass.getMethod(FACTORY_METHOD, String.class) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

