/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.lang.reflect.Array;

public class StringMultiSelectPicklistDeserializer
extends StdDeserializer<Object>
implements ContextualDeserializer {
    private static final long serialVersionUID = 7380774744798254325L;

    protected StringMultiSelectPicklistDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String listValue = jp.getText();
        try {
            String[] value = listValue.split(";");
            int length = value.length;
            Object resultArray = Array.newInstance(String.class, length);
            for (int i = 0; i < length; ++i) {
                Array.set(resultArray, i, value[i].trim());
            }
            return resultArray;
        }
        catch (Exception e) {
            throw new JsonParseException(jp, "Exception reading multi-select pick list value", jp.getCurrentLocation(), e);
        }
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) throws JsonMappingException {
        Class<?> rawClass = property.getType().getRawClass();
        Class<?> componentType = rawClass.getComponentType();
        if (componentType == null || componentType != String.class) {
            throw new JsonMappingException(context.getParser(), "Pick list String array expected for " + rawClass);
        }
        return new StringMultiSelectPicklistDeserializer(rawClass);
    }
}

