/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.dto;

import com.thoughtworks.xstream.converters.reflection.FieldKey;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.camel.component.salesforce.api.dto.XStreamFieldOrder;

public final class AnnotationFieldKeySorter
implements FieldKeySorter {
    @Override
    public Map sort(Class type, Map keyedByFieldKey) {
        Class clazz = type;
        XStreamFieldOrder fieldOrderAnnotation = clazz.getAnnotation(XStreamFieldOrder.class);
        if (fieldOrderAnnotation == null) {
            return keyedByFieldKey;
        }
        String[] fieldOrder = fieldOrderAnnotation.value();
        TreeMap sorted = new TreeMap(new AnnotationFieldOrderComparator(fieldOrder, type.getDeclaredFields()));
        sorted.putAll(keyedByFieldKey);
        return sorted;
    }

    private static final class AnnotationFieldOrderComparator
    implements Comparator<FieldKey> {
        private final SortedMap<String, Integer> order = new TreeMap<String, Integer>();

        private AnnotationFieldOrderComparator(String[] orderedFields, Field[] fields) {
            int i;
            for (i = 0; i < orderedFields.length; ++i) {
                this.order.put(orderedFields[i], i);
            }
            for (int j = 0; j < fields.length; ++j) {
                this.order.putIfAbsent(fields[j].getName(), i + j);
            }
        }

        @Override
        public int compare(FieldKey k1, FieldKey k2) {
            String field1 = k1.getFieldName();
            String field2 = k2.getFieldName();
            return ((Integer)this.order.get(field1)).compareTo((Integer)this.order.get(field2));
        }
    }
}

