/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.dto.composite;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.component.salesforce.api.dto.AbstractDescribedSObjectBase;
import org.apache.camel.component.salesforce.api.dto.AbstractSObjectBase;
import org.apache.camel.component.salesforce.api.dto.composite.BatchRequest;
import org.apache.camel.component.salesforce.api.dto.composite.CompositeRequest;
import org.apache.camel.component.salesforce.api.utils.Version;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

@XStreamAlias(value="batch")
public final class SObjectComposite
implements Serializable {
    public static final PayloadFormat REQUIRED_PAYLOAD_FORMAT = PayloadFormat.JSON;
    private static final int MAX_COMPOSITE_OPERATIONS = 25;
    private static final long serialVersionUID = 1L;
    private static final String SOBJECT_TYPE_PARAM = "type";
    private final boolean allOrNone;
    @XStreamOmitField
    private final String apiPrefix;
    private final List<CompositeRequest> compositeRequests = new ArrayList<CompositeRequest>();
    @XStreamOmitField
    private final Version version;

    public SObjectComposite(String apiVersion, boolean allOrNone) {
        Objects.requireNonNull(apiVersion, "apiVersion");
        this.version = Version.create(apiVersion);
        this.allOrNone = allOrNone;
        this.apiPrefix = "/services/data/v" + apiVersion;
    }

    public SObjectComposite addCreate(AbstractDescribedSObjectBase data, String referenceId) {
        this.addCompositeRequest(new CompositeRequest(Method.POST, this.apiPrefix + "/sobjects/" + SObjectComposite.typeOf(data) + "/", data, referenceId));
        return this;
    }

    public SObjectComposite addDelete(String type, String id, String referenceId) {
        this.addCompositeRequest(new CompositeRequest(Method.DELETE, this.rowBaseUrl(type, id), referenceId));
        return this;
    }

    public SObjectComposite addGeneric(Method method, String url, Object richInput, String referenceId) {
        this.addCompositeRequest(new CompositeRequest(method, this.apiPrefix + url, richInput, referenceId));
        return this;
    }

    public SObjectComposite addGeneric(Method method, String url, String referenceId) {
        this.addGeneric(method, url, null, referenceId);
        return this;
    }

    public SObjectComposite addGet(String type, String id, String referenceId, String ... fields) {
        String fieldsParameter = SObjectComposite.composeFieldsParameter(fields);
        this.addCompositeRequest(new CompositeRequest(Method.GET, this.rowBaseUrl(type, id) + fieldsParameter, referenceId));
        return this;
    }

    public SObjectComposite addGetByExternalId(String type, String fieldName, String fieldValue, String referenceId) {
        this.addCompositeRequest(new CompositeRequest(Method.GET, this.rowBaseUrl(type, fieldName, fieldValue), referenceId));
        return this;
    }

    public SObjectComposite addGetRelated(String type, String id, String relation, String referenceId, String ... fields) {
        this.version.requireAtLeast(36, 0);
        String fieldsParameter = SObjectComposite.composeFieldsParameter(fields);
        this.addCompositeRequest(new CompositeRequest(Method.GET, this.rowBaseUrl(type, id) + "/" + StringHelper.notEmpty((String)relation, (String)"relation") + fieldsParameter, referenceId));
        return this;
    }

    public SObjectComposite addQuery(String query, String referenceId) {
        this.addCompositeRequest(new CompositeRequest(Method.GET, this.apiPrefix + "/query/?q=" + StringHelper.notEmpty((String)query, (String)"query"), referenceId));
        return this;
    }

    public SObjectComposite addQueryAll(String query, String referenceId) {
        this.addCompositeRequest(new CompositeRequest(Method.GET, this.apiPrefix + "/queryAll/?q=" + StringHelper.notEmpty((String)query, (String)"query"), referenceId));
        return this;
    }

    public SObjectComposite addUpdate(String type, String id, AbstractSObjectBase data, String referenceId) {
        this.addCompositeRequest(new CompositeRequest(Method.PATCH, this.rowBaseUrl(type, StringHelper.notEmpty((String)id, (String)"data.Id")), data, referenceId));
        return this;
    }

    public SObjectComposite addUpdateByExternalId(String type, String fieldName, String fieldValue, AbstractSObjectBase data, String referenceId) {
        this.addCompositeRequest(new CompositeRequest(Method.PATCH, this.rowBaseUrl(type, fieldName, fieldValue), data, referenceId));
        return this;
    }

    public SObjectComposite addUpsertByExternalId(String type, String fieldName, String fieldValue, AbstractSObjectBase data, String referenceId) {
        return this.addUpdateByExternalId(type, fieldName, fieldValue, data, referenceId);
    }

    public boolean getAllOrNone() {
        return this.allOrNone;
    }

    @JsonProperty(value="compositeRequest")
    public List<CompositeRequest> getCompositeRequests() {
        return Collections.unmodifiableList(this.compositeRequests);
    }

    @JsonIgnore
    public Version getVersion() {
        return this.version;
    }

    public Class[] objectTypes() {
        Set<Class> types = Stream.concat(Stream.of(SObjectComposite.class, BatchRequest.class), this.compositeRequests.stream().map(CompositeRequest::getBody).filter(Objects::nonNull).map(Object::getClass)).collect(Collectors.toSet());
        return types.toArray(new Class[types.size()]);
    }

    void addCompositeRequest(CompositeRequest compositeRequest) {
        if (this.compositeRequests.size() >= 25) {
            throw new IllegalArgumentException("You can add up to 25 requests in a single composite request. Split your requests across multiple composite request.");
        }
        this.compositeRequests.add(compositeRequest);
    }

    String rowBaseUrl(String type, String id) {
        return this.apiPrefix + "/sobjects/" + StringHelper.notEmpty((String)type, (String)SOBJECT_TYPE_PARAM) + "/" + StringHelper.notEmpty((String)id, (String)"id");
    }

    String rowBaseUrl(String type, String fieldName, String fieldValue) {
        try {
            return this.apiPrefix + "/sobjects/" + StringHelper.notEmpty((String)type, (String)SOBJECT_TYPE_PARAM) + "/" + StringHelper.notEmpty((String)fieldName, (String)"fieldName") + "/" + URLEncoder.encode(StringHelper.notEmpty((String)fieldValue, (String)"fieldValue"), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    static String typeOf(AbstractDescribedSObjectBase data) {
        return ((AbstractDescribedSObjectBase)ObjectHelper.notNull((Object)data, (String)"data")).description().getName();
    }

    static String composeFieldsParameter(String ... fields) {
        if (fields != null && fields.length > 0) {
            try {
                return "?fields=" + URLEncoder.encode(String.join((CharSequence)",", fields), StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return "";
    }

    public static enum Method {
        DELETE,
        GET,
        PATCH,
        POST;

    }
}

