/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apache.camel.component.salesforce.api.utils.DateTimeHandling;

final class InstantConverter
implements SingleValueConverter {
    static final SingleValueConverter INSTANCE = new InstantConverter();

    private InstantConverter() {
    }

    @Override
    public boolean canConvert(Class type) {
        return Instant.class.equals((Object)type);
    }

    @Override
    public Object fromString(String value) {
        return ZonedDateTime.parse(value, DateTimeHandling.ISO_OFFSET_DATE_TIME).toInstant();
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        Instant instant = (Instant)value;
        return DateTimeHandling.ISO_OFFSET_DATE_TIME.format(instant.atZone(ZoneId.systemDefault()));
    }
}

