/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apache.camel.component.salesforce.api.utils.DateTimeHandling;

final class LocalDateTimeConverter
implements SingleValueConverter {
    static final SingleValueConverter INSTANCE = new LocalDateTimeConverter();

    private LocalDateTimeConverter() {
    }

    @Override
    public boolean canConvert(Class type) {
        return LocalDateTime.class.equals((Object)type);
    }

    @Override
    public Object fromString(String value) {
        return ZonedDateTime.parse(value, DateTimeHandling.ISO_OFFSET_DATE_TIME).toLocalDateTime();
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        LocalDateTime localDateTime = (LocalDateTime)value;
        return DateTimeHandling.ISO_OFFSET_DATE_TIME.format(localDateTime.atZone(ZoneId.systemDefault()));
    }
}

