/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import org.apache.camel.component.salesforce.api.utils.DateTimeHandling;

final class OffsetDateTimeConverter
implements SingleValueConverter {
    static final SingleValueConverter INSTANCE = new OffsetDateTimeConverter();

    private OffsetDateTimeConverter() {
    }

    @Override
    public boolean canConvert(Class type) {
        return OffsetDateTime.class.equals((Object)type);
    }

    @Override
    public Object fromString(String value) {
        return ZonedDateTime.parse(value, DateTimeHandling.ISO_OFFSET_DATE_TIME).toOffsetDateTime();
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        OffsetDateTime offsetDateTime = (OffsetDateTime)value;
        return DateTimeHandling.ISO_OFFSET_DATE_TIME.format(offsetDateTime);
    }
}

