/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.time.OffsetTime;
import org.apache.camel.component.salesforce.api.utils.DateTimeHandling;

final class OffsetTimeConverter
implements SingleValueConverter {
    static final SingleValueConverter INSTANCE = new OffsetTimeConverter();

    private OffsetTimeConverter() {
    }

    @Override
    public boolean canConvert(Class type) {
        return OffsetTime.class.equals((Object)type);
    }

    @Override
    public Object fromString(String value) {
        return OffsetTime.parse(value, DateTimeHandling.ISO_OFFSET_TIME);
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        OffsetTime offsetTime = (OffsetTime)value;
        return DateTimeHandling.ISO_OFFSET_TIME.format(offsetTime);
    }
}

