/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.api.dto.bulk.BatchInfo;
import org.apache.camel.component.salesforce.api.dto.bulk.BatchInfoList;
import org.apache.camel.component.salesforce.api.dto.bulk.ContentType;
import org.apache.camel.component.salesforce.api.dto.bulk.Error;
import org.apache.camel.component.salesforce.api.dto.bulk.JobInfo;
import org.apache.camel.component.salesforce.api.dto.bulk.JobStateEnum;
import org.apache.camel.component.salesforce.api.dto.bulk.ObjectFactory;
import org.apache.camel.component.salesforce.api.dto.bulk.QueryResultList;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.BulkApiClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultBulkApiClient
extends AbstractClientBase
implements BulkApiClient {
    private static final String TOKEN_HEADER = "X-SFDC-Session";
    private static final ContentType DEFAULT_ACCEPT_TYPE = ContentType.XML;
    private JAXBContext context;
    private ObjectFactory objectFactory;

    public DefaultBulkApiClient(String version, SalesforceSession session, SalesforceHttpClient httpClient) throws SalesforceException {
        super(version, session, httpClient);
        try {
            this.context = JAXBContext.newInstance(JobInfo.class.getPackage().getName(), this.getClass().getClassLoader());
        }
        catch (JAXBException e) {
            String msg = "Error loading Bulk API DTOs: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
        this.objectFactory = new ObjectFactory();
    }

    @Override
    public void createJob(JobInfo request, Map<String, List<String>> headers, final BulkApiClient.JobInfoResponseCallback callback) {
        this.sanitizeJobRequest(request);
        final Request post = this.getRequest(HttpMethod.POST, this.jobUrl(null), headers);
        try {
            this.marshalRequest(this.objectFactory.createJobInfo(request), post, "application/xml;charset=utf-8");
        }
        catch (SalesforceException e) {
            callback.onResponse(null, Collections.emptyMap(), e);
            return;
        }
        this.doHttpRequest(post, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                JobInfo value = null;
                if (response != null) {
                    try {
                        value = (JobInfo)DefaultBulkApiClient.this.unmarshalResponse(response, post, JobInfo.class);
                    }
                    catch (SalesforceException e) {
                        ex = e;
                    }
                }
                callback.onResponse(value, headers, ex);
            }
        });
    }

    private void sanitizeJobRequest(JobInfo request) {
        request.setApexProcessingTime(null);
        request.setApiActiveProcessingTime(null);
        request.setApiVersion(null);
        request.setCreatedById(null);
        request.setCreatedDate(null);
        request.setId(null);
        request.setNumberBatchesCompleted(null);
        request.setNumberBatchesFailed(null);
        request.setNumberBatchesInProgress(null);
        request.setNumberBatchesQueued(null);
        request.setNumberBatchesTotal(null);
        request.setNumberRecordsFailed(null);
        request.setNumberRecordsProcessed(null);
        request.setNumberRetries(null);
        request.setState(null);
        request.setSystemModstamp(null);
        request.setSystemModstamp(null);
    }

    @Override
    public void getJob(String jobId, Map<String, List<String>> headers, final BulkApiClient.JobInfoResponseCallback callback) {
        final Request get = this.getRequest(HttpMethod.GET, this.jobUrl(jobId), headers);
        this.doHttpRequest(get, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                JobInfo value = null;
                try {
                    value = (JobInfo)DefaultBulkApiClient.this.unmarshalResponse(response, get, JobInfo.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value, headers, ex);
            }
        });
    }

    @Override
    public void closeJob(String jobId, Map<String, List<String>> headers, final BulkApiClient.JobInfoResponseCallback callback) {
        JobInfo request = new JobInfo();
        request.setState(JobStateEnum.CLOSED);
        final Request post = this.getRequest(HttpMethod.POST, this.jobUrl(jobId), headers);
        try {
            this.marshalRequest(this.objectFactory.createJobInfo(request), post, "application/xml;charset=utf-8");
        }
        catch (SalesforceException e) {
            callback.onResponse(null, Collections.emptyMap(), e);
            return;
        }
        this.doHttpRequest(post, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                JobInfo value = null;
                try {
                    value = (JobInfo)DefaultBulkApiClient.this.unmarshalResponse(response, post, JobInfo.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value, headers, ex);
            }
        });
    }

    @Override
    public void abortJob(String jobId, Map<String, List<String>> headers, final BulkApiClient.JobInfoResponseCallback callback) {
        JobInfo request = new JobInfo();
        request.setState(JobStateEnum.ABORTED);
        final Request post = this.getRequest(HttpMethod.POST, this.jobUrl(jobId), headers);
        try {
            this.marshalRequest(this.objectFactory.createJobInfo(request), post, "application/xml;charset=utf-8");
        }
        catch (SalesforceException e) {
            callback.onResponse(null, Collections.emptyMap(), e);
            return;
        }
        this.doHttpRequest(post, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                JobInfo value = null;
                try {
                    value = (JobInfo)DefaultBulkApiClient.this.unmarshalResponse(response, post, JobInfo.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value, headers, ex);
            }
        });
    }

    @Override
    public void createBatch(InputStream batchStream, String jobId, ContentType contentTypeEnum, Map<String, List<String>> headers, final BulkApiClient.BatchInfoResponseCallback callback) {
        final Request post = this.getRequest(HttpMethod.POST, this.batchUrl(jobId, null), headers);
        post.content(new InputStreamContentProvider(batchStream));
        post.header(HttpHeader.CONTENT_TYPE, DefaultBulkApiClient.getContentType(contentTypeEnum) + ";charset=" + "utf-8");
        this.doHttpRequest(post, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                BatchInfo value = null;
                try {
                    value = (BatchInfo)DefaultBulkApiClient.this.unmarshalResponse(response, post, BatchInfo.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value, headers, ex);
            }
        });
    }

    @Override
    public void getBatch(String jobId, String batchId, Map<String, List<String>> headers, final BulkApiClient.BatchInfoResponseCallback callback) {
        final Request get = this.getRequest(HttpMethod.GET, this.batchUrl(jobId, batchId), headers);
        this.doHttpRequest(get, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                BatchInfo value = null;
                try {
                    value = (BatchInfo)DefaultBulkApiClient.this.unmarshalResponse(response, get, BatchInfo.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value, headers, ex);
            }
        });
    }

    @Override
    public void getAllBatches(String jobId, Map<String, List<String>> headers, final BulkApiClient.BatchInfoListResponseCallback callback) {
        final Request get = this.getRequest(HttpMethod.GET, this.batchUrl(jobId, null), headers);
        this.doHttpRequest(get, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                BatchInfoList value = null;
                try {
                    value = (BatchInfoList)DefaultBulkApiClient.this.unmarshalResponse(response, get, BatchInfoList.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value != null ? value.getBatchInfo() : null, headers, ex);
            }
        });
    }

    @Override
    public void getRequest(String jobId, String batchId, Map<String, List<String>> headers, final BulkApiClient.StreamResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.batchRequestUrl(jobId, batchId, null), headers);
        this.doHttpRequest(get, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                callback.onResponse(response, headers, ex);
            }
        });
    }

    @Override
    public void getResults(String jobId, String batchId, Map<String, List<String>> headers, final BulkApiClient.StreamResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.batchResultUrl(jobId, batchId, null), headers);
        this.doHttpRequest(get, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                callback.onResponse(response, headers, ex);
            }
        });
    }

    @Override
    public void createBatchQuery(String jobId, String soqlQuery, ContentType jobContentType, Map<String, List<String>> headers, final BulkApiClient.BatchInfoResponseCallback callback) {
        byte[] queryBytes;
        final Request post = this.getRequest(HttpMethod.POST, this.batchUrl(jobId, null), headers);
        try {
            queryBytes = soqlQuery.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            callback.onResponse(null, Collections.emptyMap(), new SalesforceException("Unexpected exception: " + e.getMessage(), e));
            return;
        }
        post.content(new BytesContentProvider(new byte[][]{queryBytes}));
        post.header(HttpHeader.CONTENT_TYPE, DefaultBulkApiClient.getContentType(jobContentType) + ";charset=" + "utf-8");
        this.doHttpRequest(post, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                BatchInfo value = null;
                try {
                    value = (BatchInfo)DefaultBulkApiClient.this.unmarshalResponse(response, post, BatchInfo.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value, headers, ex);
            }
        });
    }

    @Override
    public void getQueryResultIds(String jobId, String batchId, Map<String, List<String>> headers, final BulkApiClient.QueryResultIdsCallback callback) {
        final Request get = this.getRequest(HttpMethod.GET, this.batchResultUrl(jobId, batchId, null), headers);
        this.doHttpRequest(get, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                QueryResultList value = null;
                try {
                    value = (QueryResultList)DefaultBulkApiClient.this.unmarshalResponse(response, get, QueryResultList.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value != null ? Collections.unmodifiableList(value.getResult()) : null, headers, ex);
            }
        });
    }

    @Override
    public void getQueryResult(String jobId, String batchId, String resultId, Map<String, List<String>> headers, final BulkApiClient.StreamResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.batchResultUrl(jobId, batchId, resultId), headers);
        this.doHttpRequest(get, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                callback.onResponse(response, headers, ex);
            }
        });
    }

    @Override
    protected void setAccessToken(Request request) {
        request.getHeaders().put(TOKEN_HEADER, this.accessToken);
    }

    @Override
    protected void doHttpRequest(Request request, AbstractClientBase.ClientResponseCallback callback) {
        this.setAccessToken(request);
        request.header(HttpHeader.ACCEPT_CHARSET, "utf-8");
        if (!request.getHeaders().contains(HttpHeader.ACCEPT)) {
            String contentType = DefaultBulkApiClient.getContentType(DEFAULT_ACCEPT_TYPE);
            request.header(HttpHeader.ACCEPT, contentType);
        }
        super.doHttpRequest(request, callback);
    }

    private static String getContentType(ContentType type) {
        String result = null;
        switch (type) {
            case CSV: {
                result = "text/csv";
                break;
            }
            case XML: {
                result = "application/xml";
                break;
            }
            case ZIP_CSV: 
            case ZIP_XML: {
                result = type.toString().toLowerCase().replace('_', '/');
                break;
            }
        }
        return result;
    }

    @Override
    protected SalesforceException createRestException(Response response, InputStream responseContent) {
        try {
            Error error = this.unmarshalResponse(responseContent, response.getRequest(), Error.class);
            RestError restError = new RestError();
            restError.setErrorCode(error.getExceptionCode());
            restError.setMessage(error.getExceptionMessage());
            return new SalesforceException(Arrays.asList(restError), response.getStatus());
        }
        catch (SalesforceException e) {
            String msg = "Error un-marshaling Salesforce Error: " + e.getMessage();
            return new SalesforceException(msg, (Throwable)((Object)e));
        }
    }

    private <T> T unmarshalResponse(InputStream response, Request request, Class<T> resultClass) throws SalesforceException {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            try {
                spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
                spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
            SAXSource xmlSource = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(response));
            JAXBElement<T> result = unmarshaller.unmarshal(xmlSource, resultClass);
            return result.getValue();
        }
        catch (JAXBException | ParserConfigurationException | SAXException e) {
            throw new SalesforceException(String.format("Error unmarshaling response {%s:%s} : %s", request.getMethod(), request.getURI(), e.getMessage()), e);
        }
        catch (IllegalArgumentException e) {
            throw new SalesforceException(String.format("Error unmarshaling response for {%s:%s} : %s", request.getMethod(), request.getURI(), e.getMessage()), e);
        }
    }

    private void marshalRequest(Object input, Request request, String contentType) throws SalesforceException {
        try {
            Marshaller marshaller = this.context.createMarshaller();
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            marshaller.marshal(input, byteStream);
            request.content(new BytesContentProvider(contentType, (byte[][])new byte[][]{byteStream.toByteArray()}));
        }
        catch (JAXBException e) {
            throw new SalesforceException(String.format("Error marshaling request for {%s:%s} : %s", request.getMethod(), request.getURI(), e.getMessage()), e);
        }
        catch (IllegalArgumentException e) {
            throw new SalesforceException(String.format("Error marshaling request for {%s:%s} : %s", request.getMethod(), request.getURI(), e.getMessage()), e);
        }
    }

    private String jobUrl(String jobId) {
        if (jobId != null) {
            return this.instanceUrl + "/services/async/" + this.version + "/job/" + jobId;
        }
        return this.instanceUrl + "/services/async/" + this.version + "/job";
    }

    private String batchUrl(String jobId, String batchId) {
        if (batchId != null) {
            return this.jobUrl(jobId) + "/batch/" + batchId;
        }
        return this.jobUrl(jobId) + "/batch";
    }

    private String batchResultUrl(String jobId, String batchId, String resultId) {
        if (resultId != null) {
            return this.batchUrl(jobId, batchId) + "/result/" + resultId;
        }
        return this.batchUrl(jobId, batchId) + "/result";
    }

    private String batchRequestUrl(String jobId, String batchId, String requestId) {
        if (requestId != null) {
            return this.batchUrl(jobId, batchId) + "/request/" + requestId;
        }
        return this.batchUrl(jobId, batchId) + "/request";
    }
}

