/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sap.netweaver;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.component.sap.netweaver.NetWeaverEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.codehaus.jackson.map.ObjectMapper;

public class NetWeaverProducer
extends DefaultProducer {
    private Producer http;

    public NetWeaverProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public NetWeaverEndpoint getEndpoint() {
        return (NetWeaverEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String command = (String)ExchangeHelper.getMandatoryHeader((Exchange)exchange, (String)"CamelNetWeaverCommand", String.class);
        Exchange httpExchange = this.getEndpoint().createExchange();
        httpExchange.getIn().setHeader("CamelHttpPath", (Object)command);
        if (this.getEndpoint().isJson()) {
            httpExchange.getIn().setHeader("Accept", (Object)"application/json");
        }
        this.log.debug("Calling SAP Net-Weaver {} with command {}", (Object)this.http, (Object)command);
        this.http.process(httpExchange);
        String data = (String)httpExchange.getOut().getBody(String.class);
        if (data != null && this.getEndpoint().isJsonAsMap() && this.getEndpoint().isJson()) {
            ObjectMapper mapper = new ObjectMapper();
            Map map = mapper.readValue(data, Map.class);
            if (map.size() == 1 && this.getEndpoint().isFlatternMap()) {
                exchange.getIn().setBody(map.values().iterator().next());
            } else {
                exchange.getIn().setBody((Object)map);
            }
        } else {
            exchange.getIn().setBody((Object)data);
        }
    }

    protected void doStart() throws Exception {
        String url = this.getEndpoint().getUrl() + "?authUsername=" + this.getEndpoint().getUsername() + "&authPassword=" + this.getEndpoint().getPassword() + "&authMethod=Basic";
        if (this.log.isInfoEnabled()) {
            this.log.info("Creating NetWeaverProducer using url: {}", (Object)URISupport.sanitizeUri((String)url));
        }
        this.http = this.getEndpoint().getCamelContext().getEndpoint(url).createProducer();
        ServiceHelper.startService((Service)this.http);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.http);
    }
}

