/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.Service;
import org.apache.camel.VerifiableComponent;
import org.apache.camel.component.http.AuthMethod;
import org.apache.camel.component.http.BasicAuthenticationHttpClientConfigurer;
import org.apache.camel.component.http.CompositeHttpConfigurer;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpComponentVerifier;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.NTLMAuthenticationHttpClientConfigurer;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpCommonComponent;
import org.apache.camel.http.common.HttpConfiguration;
import org.apache.camel.http.common.HttpRestHeaderFilterStrategy;
import org.apache.camel.http.common.UrlRewrite;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

@Metadata(label="verifiers", enums="parameters,connectivity")
public class HttpComponent
extends HttpCommonComponent
implements RestProducerFactory,
VerifiableComponent,
SSLContextParametersAware {
    @Metadata(label="advanced")
    protected HttpClientConfigurer httpClientConfigurer;
    @Metadata(label="advanced")
    protected HttpConnectionManager httpConnectionManager;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public HttpComponent() {
        super(HttpEndpoint.class);
    }

    public HttpComponent(Class<? extends HttpEndpoint> endpointClass) {
        super(endpointClass);
    }

    protected HttpClientConfigurer createHttpClientConfigurer(Map<String, Object> parameters, Set<AuthMethod> authMethods) {
        HttpClientConfigurer configurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurer", HttpClientConfigurer.class);
        if (configurer == null) {
            configurer = this.getHttpClientConfigurer();
        }
        String authUsername = this.getParameter(parameters, "authUsername", String.class);
        String authMethod = this.getParameter(parameters, "authMethod", String.class);
        if (authUsername != null && authMethod == null) {
            throw new IllegalArgumentException("Option authMethod must be provided to use authentication");
        }
        if (authMethod != null) {
            String authPassword = this.getParameter(parameters, "authPassword", String.class);
            String authDomain = this.getParameter(parameters, "authDomain", String.class);
            String authHost = this.getParameter(parameters, "authHost", String.class);
            configurer = this.configureAuth(configurer, authMethod, authUsername, authPassword, authDomain, authHost, authMethods);
        } else if (this.httpConfiguration != null) {
            configurer = this.configureAuth(configurer, this.httpConfiguration.getAuthMethod(), this.httpConfiguration.getAuthUsername(), this.httpConfiguration.getAuthPassword(), this.httpConfiguration.getAuthDomain(), this.httpConfiguration.getAuthHost(), authMethods);
        }
        String proxyAuthUsername = this.getParameter(parameters, "proxyAuthUsername", String.class);
        String proxyAuthMethod = this.getParameter(parameters, "proxyAuthMethod", String.class);
        if (proxyAuthUsername != null && proxyAuthMethod == null) {
            throw new IllegalArgumentException("Option proxyAuthMethod must be provided to use proxy authentication");
        }
        if (proxyAuthMethod != null) {
            String proxyAuthPassword = this.getParameter(parameters, "proxyAuthPassword", String.class);
            String proxyAuthDomain = this.getParameter(parameters, "proxyAuthDomain", String.class);
            String proxyAuthHost = this.getParameter(parameters, "proxyAuthHost", String.class);
            configurer = this.configureProxyAuth(configurer, proxyAuthMethod, proxyAuthUsername, proxyAuthPassword, proxyAuthDomain, proxyAuthHost, authMethods);
        } else if (this.httpConfiguration != null) {
            configurer = this.configureProxyAuth(configurer, this.httpConfiguration.getProxyAuthMethod(), this.httpConfiguration.getProxyAuthUsername(), this.httpConfiguration.getProxyAuthPassword(), this.httpConfiguration.getProxyAuthDomain(), this.httpConfiguration.getProxyAuthHost(), authMethods);
        }
        return configurer;
    }

    protected HttpClientConfigurer configureAuth(HttpClientConfigurer configurer, String authMethod, String username, String password, String domain, String host, Set<AuthMethod> authMethods) {
        if (username == null && authMethod == null) {
            return configurer;
        }
        if (username != null && authMethod == null) {
            throw new IllegalArgumentException("Option authMethod must be provided to use authentication");
        }
        ObjectHelper.notNull((Object)authMethod, (String)"authMethod");
        ObjectHelper.notNull((Object)username, (String)"authUsername");
        ObjectHelper.notNull((Object)password, (String)"authPassword");
        AuthMethod auth = (AuthMethod)((Object)this.getCamelContext().getTypeConverter().convertTo(AuthMethod.class, (Object)authMethod));
        authMethods.add(auth);
        if (auth == AuthMethod.Basic || auth == AuthMethod.Digest) {
            return CompositeHttpConfigurer.combineConfigurers(configurer, new BasicAuthenticationHttpClientConfigurer(false, username, password));
        }
        if (auth == AuthMethod.NTLM) {
            ObjectHelper.notNull((Object)domain, (String)"authDomain");
            return CompositeHttpConfigurer.combineConfigurers(configurer, new NTLMAuthenticationHttpClientConfigurer(false, username, password, domain, host));
        }
        throw new IllegalArgumentException("Unknown authMethod " + authMethod);
    }

    protected HttpClientConfigurer configureProxyAuth(HttpClientConfigurer configurer, String authMethod, String username, String password, String domain, String host, Set<AuthMethod> authMethods) {
        if (username == null && authMethod == null) {
            return configurer;
        }
        if (username != null && authMethod == null) {
            throw new IllegalArgumentException("Option proxyAuthMethod must be provided to use proxy authentication");
        }
        ObjectHelper.notNull((Object)authMethod, (String)"proxyAuthMethod");
        ObjectHelper.notNull((Object)username, (String)"proxyAuthUsername");
        ObjectHelper.notNull((Object)password, (String)"proxyAuthPassword");
        AuthMethod auth = (AuthMethod)((Object)this.getCamelContext().getTypeConverter().convertTo(AuthMethod.class, (Object)authMethod));
        authMethods.add(auth);
        if (auth == AuthMethod.Basic || auth == AuthMethod.Digest) {
            return CompositeHttpConfigurer.combineConfigurers(configurer, new BasicAuthenticationHttpClientConfigurer(true, username, password));
        }
        if (auth == AuthMethod.NTLM) {
            ObjectHelper.notNull((Object)domain, (String)"proxyAuthDomain");
            return CompositeHttpConfigurer.combineConfigurers(configurer, new NTLMAuthenticationHttpClientConfigurer(true, username, password, domain, host));
        }
        throw new IllegalArgumentException("Unknown proxyAuthMethod " + authMethod);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String addressUri = "http://" + remaining;
        if (uri.startsWith("https:")) {
            addressUri = "https://" + remaining;
        }
        HashMap<String, Object> httpClientParameters = new HashMap<String, Object>(parameters);
        HttpBinding binding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBinding", HttpBinding.class);
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        UrlRewrite urlRewrite = (UrlRewrite)this.resolveAndRemoveReferenceParameter(parameters, "urlRewrite", UrlRewrite.class);
        HttpClientParams clientParams = new HttpClientParams();
        Map httpClientOptions = IntrospectionSupport.extractProperties(parameters, (String)"httpClient.");
        IntrospectionSupport.setProperties((Object)clientParams, (Map)httpClientOptions);
        this.validateParameters(uri, httpClientOptions, null);
        HttpConnectionManagerParams connectionManagerParams = new HttpConnectionManagerParams();
        Map httpConnectionManagerOptions = IntrospectionSupport.extractProperties(parameters, (String)"httpConnectionManager.");
        IntrospectionSupport.setProperties((Object)connectionManagerParams, (Map)httpConnectionManagerOptions);
        this.validateParameters(uri, httpConnectionManagerOptions, null);
        HttpConnectionManager thisHttpConnectionManager = this.httpConnectionManager;
        if (thisHttpConnectionManager == null) {
            thisHttpConnectionManager = new MultiThreadedHttpConnectionManager();
            thisHttpConnectionManager.setParams(connectionManagerParams);
        }
        LinkedHashSet<AuthMethod> authMethods = new LinkedHashSet<AuthMethod>();
        HttpClientConfigurer configurer = this.createHttpClientConfigurer(parameters, authMethods);
        addressUri = UnsafeUriCharactersEncoder.encodeHttpURI((String)addressUri);
        URI endpointUri = URISupport.createRemainingURI((URI)new URI(addressUri), httpClientParameters);
        HttpEndpoint endpoint = this.createHttpEndpoint(endpointUri.toString(), this, clientParams, thisHttpConnectionManager, configurer);
        if (this.getHttpConfiguration() != null) {
            HashMap properties = new HashMap();
            IntrospectionSupport.getProperties((Object)this.getHttpConfiguration(), properties, null);
            this.setProperties((Object)endpoint, properties);
        }
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        }
        if (urlRewrite != null) {
            this.getCamelContext().addService((Object)urlRewrite);
            endpoint.setUrlRewrite(urlRewrite);
        }
        if (binding == null) {
            binding = this.getHttpBinding();
        }
        if (binding != null) {
            endpoint.setBinding(binding);
        }
        this.setProperties((Object)endpoint, parameters);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(addressUri), parameters);
        String part = httpUri.getSchemeSpecificPart();
        if (part != null && ((part = part.toLowerCase()).startsWith("//http//") || part.startsWith("//https//") || part.startsWith("//http://") || part.startsWith("//https://"))) {
            throw new ResolveEndpointFailedException(uri, "The uri part is not configured correctly. You have duplicated the http(s) protocol.");
        }
        endpoint.setHttpUri(httpUri);
        endpoint.setHttpClientOptions(httpClientOptions);
        return endpoint;
    }

    protected HttpEndpoint createHttpEndpoint(String uri, HttpComponent component, HttpClientParams clientParams, HttpConnectionManager connectionManager, HttpClientConfigurer configurer) throws URISyntaxException {
        return new HttpEndpoint(uri, component, clientParams, connectionManager, configurer);
    }

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, Map<String, Object> parameters) throws Exception {
        basePath = FileUtil.stripLeadingSeparator((String)basePath);
        uriTemplate = FileUtil.stripLeadingSeparator((String)uriTemplate);
        String url = host;
        if (!ObjectHelper.isEmpty((Object)basePath)) {
            url = url + "/" + basePath;
        }
        if (!ObjectHelper.isEmpty((Object)uriTemplate)) {
            url = url + "/" + uriTemplate;
        }
        HttpEndpoint endpoint = (HttpEndpoint)camelContext.getEndpoint(url, HttpEndpoint.class);
        if (parameters != null && !parameters.isEmpty()) {
            this.setProperties(camelContext, (Object)endpoint, parameters);
        }
        String path = uriTemplate != null ? uriTemplate : basePath;
        endpoint.setHeaderFilterStrategy((HeaderFilterStrategy)new HttpRestHeaderFilterStrategy(path, queryParameters));
        ServiceHelper.startService((Service)endpoint);
        return endpoint.createProducer();
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    @Override
    public void setHttpBinding(HttpBinding httpBinding) {
        super.setHttpBinding(httpBinding);
    }

    @Override
    public void setHttpConfiguration(HttpConfiguration httpConfiguration) {
        super.setHttpConfiguration(httpConfiguration);
    }

    @Override
    public void setAllowJavaSerializedObject(boolean allowJavaSerializedObject) {
        super.setAllowJavaSerializedObject(allowJavaSerializedObject);
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public ComponentVerifier getVerifier() {
        return new HttpComponentVerifier(this);
    }
}

