/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.Consumer;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.http.AuthMethod;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpPollingConsumer;
import org.apache.camel.component.http.HttpProducer;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="1.0.0", scheme="http,https", title="HTTP,HTTPS", syntax="http:httpUri", producerOnly=true, label="http", lenientProperties=true)
public class HttpEndpoint
extends HttpCommonEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(HttpEndpoint.class);
    private HttpClientParams clientParams;
    @UriParam(label="advanced")
    private HttpClientConfigurer httpClientConfigurer;
    @UriParam(label="advanced", prefix="httpClient.", multiValue=true)
    private Map<String, Object> httpClientOptions;
    @UriParam(label="advanced")
    private HttpConnectionManager httpConnectionManager;
    @UriParam(label="advanced", prefix="httpConnectionManager.", multiValue=true)
    private Map<String, Object> httpConnectionManagerOptions;

    public HttpEndpoint() {
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI) throws URISyntaxException {
        this(endPointURI, component, httpURI, null);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI, HttpConnectionManager httpConnectionManager) throws URISyntaxException {
        this(endPointURI, component, httpURI, new HttpClientParams(), httpConnectionManager, null);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, HttpClientParams clientParams, HttpConnectionManager httpConnectionManager, HttpClientConfigurer clientConfigurer) throws URISyntaxException {
        this(endPointURI, component, null, clientParams, httpConnectionManager, clientConfigurer);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI, HttpClientParams clientParams, HttpConnectionManager httpConnectionManager, HttpClientConfigurer clientConfigurer) throws URISyntaxException {
        super(endPointURI, component, httpURI);
        this.clientParams = clientParams;
        this.httpClientConfigurer = clientConfigurer;
        this.httpConnectionManager = httpConnectionManager;
    }

    public Producer createProducer() throws Exception {
        return new HttpProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from http endpoint");
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        HttpPollingConsumer answer = new HttpPollingConsumer(this);
        this.configurePollingConsumer((PollingConsumer)answer);
        return answer;
    }

    public HttpClient createHttpClient() {
        ObjectHelper.notNull((Object)this.clientParams, (String)"clientParams");
        ObjectHelper.notNull((Object)this.httpConnectionManager, (String)"httpConnectionManager");
        HttpClient answer = new HttpClient(this.getClientParams());
        if (ObjectHelper.isNotEmpty((Object)this.getCamelContext().getProperty("http.proxyHost")) && ObjectHelper.isNotEmpty((Object)this.getCamelContext().getProperty("http.proxyPort"))) {
            String host = this.getCamelContext().getProperty("http.proxyHost");
            int port = Integer.parseInt(this.getCamelContext().getProperty("http.proxyPort"));
            LOG.debug("CamelContext properties http.proxyHost and http.proxyPort detected. Using http proxy host: {} port: {}", (Object)host, (Object)port);
            answer.getHostConfiguration().setProxy(host, port);
        }
        if (this.getProxyHost() != null) {
            LOG.debug("Using proxy: {}:{}", (Object)this.getProxyHost(), (Object)this.getProxyPort());
            answer.getHostConfiguration().setProxy(this.getProxyHost(), this.getProxyPort());
        }
        if (this.getAuthMethodPriority() != null) {
            ArrayList<String> authPrefs = new ArrayList<String>();
            Iterator it = (Iterator)this.getCamelContext().getTypeConverter().convertTo(Iterator.class, (Object)this.getAuthMethodPriority());
            int i = 1;
            while (it.hasNext()) {
                Object value = it.next();
                AuthMethod auth = (AuthMethod)((Object)this.getCamelContext().getTypeConverter().convertTo(AuthMethod.class, value));
                if (auth == null) {
                    throw new IllegalArgumentException("Unknown authMethod: " + value + " in authMethodPriority: " + this.getAuthMethodPriority());
                }
                LOG.debug("Using authSchemePriority #{}: {}", (Object)i, (Object)auth);
                authPrefs.add(auth.name());
                ++i;
            }
            if (!authPrefs.isEmpty()) {
                answer.getParams().setParameter("http.auth.scheme-priority", authPrefs);
            }
        }
        answer.setHttpConnectionManager(this.httpConnectionManager);
        HttpClientConfigurer configurer = this.getHttpClientConfigurer();
        if (configurer != null) {
            configurer.configureHttpClient(answer);
        }
        return answer;
    }

    public HttpClientParams getClientParams() {
        return this.clientParams;
    }

    public void setClientParams(HttpClientParams clientParams) {
        this.clientParams = clientParams;
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    public Map<String, Object> getHttpClientOptions() {
        return this.httpClientOptions;
    }

    public void setHttpClientOptions(Map<String, Object> httpClientOptions) {
        this.httpClientOptions = httpClientOptions;
    }

    public Map<String, Object> getHttpConnectionManagerOptions() {
        return this.httpConnectionManagerOptions;
    }

    public void setHttpConnectionManagerOptions(Map<String, Object> httpConnectionManagerOptions) {
        this.httpConnectionManagerOptions = httpConnectionManagerOptions;
    }
}

