/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.impl.PollingConsumerSupport;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class HttpPollingConsumer
extends PollingConsumerSupport
implements ServicePoolAware {
    private final HttpEndpoint endpoint;
    private HttpClient httpClient;

    public HttpPollingConsumer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.httpClient = endpoint.createHttpClient();
    }

    public Exchange receive() {
        return this.doReceive(-1);
    }

    public Exchange receive(long timeout) {
        return this.doReceive((int)timeout);
    }

    public Exchange receiveNoWait() {
        return this.doReceive(-1);
    }

    protected Exchange doReceive(int timeout) {
        Exchange exchange = this.endpoint.createExchange();
        HttpMethod method = this.createMethod(exchange);
        if (timeout > 0) {
            method.getParams().setSoTimeout(timeout);
        }
        try {
            int responseCode = this.httpClient.executeMethod(method);
            Object body = HttpHelper.readResponseBodyFromInputStream(method.getResponseBodyAsStream(), exchange);
            Message message = exchange.getOut();
            message.setBody(body);
            Exchange headers = method.getResponseHeaders();
            HeaderFilterStrategy strategy = this.endpoint.getHeaderFilterStrategy();
            for (Header header : headers) {
                String name = header.getName();
                if (name.toLowerCase().equals("content-type")) {
                    name = "Content-Type";
                }
                String value = header.getValue();
                if (strategy == null || strategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
                message.setHeader(name, (Object)value);
            }
            message.setHeader("CamelHttpResponseCode", (Object)responseCode);
            message.setHeader("CamelHttpResponseText", (Object)method.getStatusText());
            Exchange exchange2 = exchange;
            return exchange2;
        }
        catch (IOException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected HttpMethod createMethod(Exchange exchange) {
        String uri = HttpHelper.createURL(exchange, this.endpoint);
        return new GetMethod(uri);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

