/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.saxon;

import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.TypeConverterRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Converter
public final class SaxonConverter {
    private SaxonConverter() {
    }

    @Converter
    public static Document toDOMDocument(NodeInfo node) throws XPathException {
        switch (node.getNodeKind()) {
            case 9: {
                return (Document)((Object)NodeOverNodeInfo.wrap(node));
            }
            case 1: {
                Configuration config = node.getConfiguration();
                DocumentInfo documentInfo = config.buildDocument(node);
                return (Document)((Object)NodeOverNodeInfo.wrap(documentInfo));
            }
        }
        return null;
    }

    @Converter
    public static Node toDOMNode(NodeInfo node) {
        return NodeOverNodeInfo.wrap(node);
    }

    @Converter
    public static DOMSource toDOMSourceFromNodeInfo(NodeInfo nodeInfo) {
        return new DOMSource(SaxonConverter.toDOMNode(nodeInfo));
    }

    @Converter
    public static NodeList toDOMNodeList(List<? extends NodeInfo> nodeList) {
        LinkedList<Node> domNodeList = new LinkedList<Node>();
        if (nodeList != null) {
            for (NodeInfo nodeInfo : nodeList) {
                domNodeList.add(NodeOverNodeInfo.wrap(nodeInfo));
            }
        }
        return new DOMNodeList(domNodeList);
    }

    @FallbackConverter
    public static <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        TypeConverter tc;
        if (NodeInfo.class.isAssignableFrom(value.getClass())) {
            NodeInfo ni = (NodeInfo)value;
            TypeConverter tc2 = registry.lookup(type, Node.class);
            if (tc2 != null) {
                NodeOverNodeInfo node = NodeOverNodeInfo.wrap(ni);
                return (T)tc2.convertTo(type, exchange, (Object)node);
            }
            tc2 = registry.lookup(type, NodeList.class);
            if (tc2 != null) {
                LinkedList<NodeInfo> nil = new LinkedList<NodeInfo>();
                nil.add((NodeInfo)value);
                return (T)tc2.convertTo(type, exchange, (Object)SaxonConverter.toDOMNodeList(nil));
            }
        } else if (List.class.isAssignableFrom(value.getClass())) {
            TypeConverter tc3 = registry.lookup(type, NodeList.class);
            if (tc3 != null) {
                LinkedList<NodeInfo> lion = new LinkedList<NodeInfo>();
                for (Object o : (List)value) {
                    if (!(o instanceof NodeInfo)) continue;
                    lion.add((NodeInfo)o);
                }
                if (lion.size() > 0) {
                    NodeList nl = SaxonConverter.toDOMNodeList(lion);
                    return (T)tc3.convertTo(type, exchange, (Object)nl);
                }
            }
        } else if (NodeOverNodeInfo.class.isAssignableFrom(value.getClass()) && (tc = registry.lookup(type, NodeList.class)) != null) {
            LinkedList<Node> domNodeList = new LinkedList<Node>();
            domNodeList.add((NodeOverNodeInfo)value);
            return (T)tc.convertTo(type, exchange, (Object)new DOMNodeList(domNodeList));
        }
        return null;
    }
}

