/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.number.NumberFormatter;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.Number_1;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberInstruction
extends Expression {
    public static final int SINGLE = 0;
    public static final int MULTI = 1;
    public static final int ANY = 2;
    public static final int SIMPLE = 3;
    public static final String[] LEVEL_NAMES = new String[]{"single", "multi", "any", "simple"};
    private Operand selectOp;
    private Operand valueOp;
    private Operand formatOp;
    private Operand groupSizeOp;
    private Operand groupSeparatorOp;
    private Operand letterValueOp;
    private Operand ordinalOp;
    private Operand startAtOp;
    private Operand langOp;
    private int level;
    private Pattern count = null;
    private Pattern from = null;
    private NumberFormatter formatter = null;
    private Numberer numberer = null;
    private boolean hasVariablesInPatterns;
    private boolean backwardsCompatible;

    public NumberInstruction(Expression select, int level, Pattern count, Pattern from, Expression value, Expression format, Expression groupSize, Expression groupSeparator, Expression letterValue, Expression ordinal, Expression startAt, Expression lang, NumberFormatter formatter, boolean hasVariablesInPatterns, boolean backwardsCompatible) {
        if (value != null) {
            this.valueOp = new Operand(this, value, OperandRole.SINGLE_ATOMIC);
        }
        if (select != null) {
            this.selectOp = new Operand(this, select, new OperandRole(0, OperandUsage.NAVIGATION, SequenceType.SINGLE_NODE));
        }
        if (format != null) {
            this.formatOp = new Operand(this, format, OperandRole.SINGLE_ATOMIC);
        }
        if (groupSize != null) {
            this.groupSizeOp = new Operand(this, groupSize, OperandRole.SINGLE_ATOMIC);
        }
        if (groupSeparator != null) {
            this.groupSeparatorOp = new Operand(this, groupSeparator, OperandRole.SINGLE_ATOMIC);
        }
        if (letterValue != null) {
            this.letterValueOp = new Operand(this, letterValue, OperandRole.SINGLE_ATOMIC);
        }
        if (ordinal != null) {
            this.ordinalOp = new Operand(this, ordinal, OperandRole.SINGLE_ATOMIC);
        }
        if (startAt != null) {
            this.startAtOp = new Operand(this, startAt, OperandRole.SINGLE_ATOMIC);
        }
        if (lang != null) {
            this.langOp = new Operand(this, lang, OperandRole.SINGLE_ATOMIC);
        }
        this.level = level;
        this.count = count;
        this.from = from;
        this.formatter = formatter;
        this.hasVariablesInPatterns = hasVariablesInPatterns;
        this.backwardsCompatible = backwardsCompatible;
        this.hasVariablesInPatterns = count != null && (count.getDependencies() & 0x80) != 0;
    }

    @Override
    public Expression simplify() throws XPathException {
        if (this.valueOp != null && !this.valueOp.getChildExpression().getItemType().isPlainType()) {
            this.valueOp.setChildExpression(Atomizer.makeAtomizer(this.valueOp.getChildExpression()));
        }
        this.preallocateNumberer(this.getConfiguration());
        return super.simplify();
    }

    public void preallocateNumberer(Configuration config) throws XPathException {
        if (this.langOp == null) {
            this.numberer = config.makeNumberer(null, null);
        } else if (this.langOp.getChildExpression() instanceof StringLiteral) {
            ValidationFailure vf;
            String language = ((StringLiteral)this.langOp.getChildExpression()).getStringValue();
            if (language.length() != 0 && (vf = StringConverter.STRING_TO_LANGUAGE.validate(language)) != null) {
                this.langOp.setChildExpression(new StringLiteral(StringValue.EMPTY_STRING));
                throw new XPathException("The lang attribute must be a valid language code", "XTDE0030");
            }
            this.numberer = config.makeNumberer(language, null);
        }
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        if (this.selectOp == null && this.valueOp == null) {
            XPathException err = null;
            if (contextInfo == null || contextInfo.getItemType() == null) {
                err = new XPathException("xsl:number requires a select attribute, a value attribute, or a context item");
            } else if (contextInfo.getItemType().isPlainType()) {
                err = new XPathException("xsl:number requires the context item to be a node, but it is an atomic value");
            }
            if (err != null) {
                err.setIsTypeError(true);
                err.setErrorCode("XTTE0990");
                err.setLocation(this.getLocation());
                throw err;
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.optimizeChildren(visitor, contextInfo);
        return this;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> sub = new ArrayList<Operand>(9);
        for (Operand o : this.operandSparseList(this.selectOp, this.valueOp, this.formatOp, this.groupSizeOp, this.groupSeparatorOp, this.letterValueOp, this.ordinalOp, this.startAtOp, this.langOp)) {
            sub.add(o);
        }
        if (this.count != null) {
            sub.add(new Operand(this, this.count, OperandRole.INSPECT));
        }
        if (this.from != null) {
            sub.add(new Operand(this, this.from, OperandRole.INSPECT));
        }
        return sub;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        NumberInstruction exp = new NumberInstruction(this.copy(this.selectOp, rebindings), this.level, this.count, this.from, this.copy(this.valueOp, rebindings), this.copy(this.formatOp, rebindings), this.copy(this.groupSizeOp, rebindings), this.copy(this.groupSeparatorOp, rebindings), this.copy(this.letterValueOp, rebindings), this.copy(this.ordinalOp, rebindings), this.copy(this.startAtOp, rebindings), this.copy(this.langOp, rebindings), this.formatter, this.hasVariablesInPatterns, this.backwardsCompatible);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    private Expression copy(Operand op, RebindingMap rebindings) {
        return op == null ? null : op.getChildExpression().copy(rebindings);
    }

    @Override
    public int getIntrinsicDependencies() {
        return this.selectOp == null ? 2 : 0;
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.STRING;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public void promoteChildren(PromotionOffer offer) throws XPathException {
        super.promoteChildren(offer);
        if (this.count != null) {
            this.count.promote(offer, this);
        }
        if (this.from != null) {
            this.from.promote(offer, this);
        }
    }

    @Override
    public String toShortString() {
        return "xsl:number";
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        NumberFormatter nf;
        String letterVal;
        long value = -1L;
        List<Object> vec = null;
        ConversionRules rules = context.getConfiguration().getConversionRules();
        String startAv = this.startAtOp.getChildExpression().evaluateAsString(context).toString();
        List<Integer> startValues = this.parseStartAtValue(startAv);
        if (this.valueOp != null) {
            AtomicValue val;
            SequenceIterator iter = this.valueOp.getChildExpression().iterate(context);
            vec = new ArrayList<String>(4);
            int pos = 0;
            while ((val = (AtomicValue)iter.next()) != null && (!this.backwardsCompatible || vec.isEmpty())) {
                int startValue = startValues.size() > pos ? startValues.get(pos) : startValues.get(startValues.size() - 1);
                ++pos;
                try {
                    NumericValue num = val instanceof NumericValue ? (NumericValue)val : Number_1.convert(val, context.getConfiguration());
                    if (num.isNaN()) {
                        throw new XPathException("NaN");
                    }
                    if ((num = num.round(0)).compareTo(Int64Value.MAX_LONG) > 0) {
                        BigInteger bi = ((BigIntegerValue)Converter.convert(num, BuiltInAtomicType.INTEGER, rules).asAtomic()).asBigInteger();
                        if (startValue != 1) {
                            bi = bi.add(BigInteger.valueOf(startValue - 1));
                        }
                        vec.add(bi);
                        continue;
                    }
                    if (num.compareTo(Int64Value.ZERO) < 0) {
                        throw new XPathException("The numbers to be formatted must not be negative");
                    }
                    long i = ((NumericValue)Converter.convert(num, BuiltInAtomicType.INTEGER, rules).asAtomic()).longValue();
                    vec.add(i += (long)(startValue - 1));
                }
                catch (XPathException err) {
                    if (this.backwardsCompatible) {
                        vec.add("NaN");
                        continue;
                    }
                    vec.add(val.getStringValue());
                    XPathException e = new XPathException("Cannot convert supplied value to an integer. " + err.getMessage());
                    e.setErrorCode("XTDE0980");
                    e.setLocation(this.getLocation());
                    e.setXPathContext(context);
                    throw e;
                }
            }
            if (this.backwardsCompatible && vec.isEmpty()) {
                vec.add("NaN");
            }
        } else {
            NodeInfo source;
            if (this.selectOp != null) {
                source = (NodeInfo)this.selectOp.getChildExpression().evaluateItem(context);
            } else {
                Item item = context.getContextItem();
                if (!(item instanceof NodeInfo)) {
                    XPathException err = new XPathException("context item for xsl:number must be a node");
                    err.setErrorCode("XTTE0990");
                    err.setIsTypeError(true);
                    err.setXPathContext(context);
                    err.setLocation(this.getLocation());
                    throw err;
                }
                source = (NodeInfo)item;
            }
            if (this.level == 3) {
                value = Navigator.getNumberSimple(source, context);
                value += (long)(startValues.get(0) - 1);
            } else if (this.level == 0) {
                value = Navigator.getNumberSingle(source, this.count, this.from, context);
                if (value == 0L) {
                    vec = Collections.emptyList();
                } else {
                    value += (long)(startValues.get(0) - 1);
                }
            } else if (this.level == 2) {
                value = Navigator.getNumberAny(this, source, this.count, this.from, context, this.hasVariablesInPatterns);
                if (value == 0L) {
                    vec = Collections.emptyList();
                } else {
                    value += (long)(startValues.get(0) - 1);
                }
            } else if (this.level == 1) {
                vec = new ArrayList();
                int pos = 0;
                for (long n : Navigator.getNumberMulti(source, this.count, this.from, context)) {
                    int startValue = startValues.size() > pos ? startValues.get(pos) : startValues.get(startValues.size() - 1);
                    ++pos;
                    vec.add(n + (long)startValue - 1L);
                }
            }
        }
        int gpsize = 0;
        String gpseparator = "";
        String ordinalVal = null;
        if (this.groupSizeOp != null) {
            String g = this.groupSizeOp.getChildExpression().evaluateAsString(context).toString();
            try {
                gpsize = Integer.parseInt(g);
            }
            catch (NumberFormatException err) {
                XPathException e = new XPathException("grouping-size must be numeric");
                e.setXPathContext(context);
                e.setErrorCode("XTDE0030");
                e.setLocation(this.getLocation());
                throw e;
            }
        }
        if (this.groupSeparatorOp != null) {
            gpseparator = this.groupSeparatorOp.getChildExpression().evaluateAsString(context).toString();
        }
        if (this.ordinalOp != null) {
            ordinalVal = this.ordinalOp.getChildExpression().evaluateAsString(context).toString();
        }
        if (vec == null && this.formatOp == null && gpsize == 0 && this.langOp == null) {
            return new StringValue("" + value);
        }
        Numberer numb = this.numberer;
        if (numb == null) {
            if (this.langOp == null) {
                numb = context.getConfiguration().makeNumberer(null, null);
            } else {
                String language = this.langOp.getChildExpression().evaluateAsString(context).toString();
                ValidationFailure vf = StringConverter.STRING_TO_LANGUAGE.validate(language);
                if (vf != null) {
                    throw new XPathException("The lang attribute of xsl:number must be a valid language code", "XTDE0030");
                }
                numb = context.getConfiguration().makeNumberer(language, null);
            }
        }
        if (this.letterValueOp == null) {
            letterVal = "";
        } else {
            letterVal = this.letterValueOp.getChildExpression().evaluateAsString(context).toString();
            if (!"alphabetic".equals(letterVal) && !"traditional".equals(letterVal)) {
                XPathException e = new XPathException("letter-value must be \"traditional\" or \"alphabetic\"");
                e.setXPathContext(context);
                e.setErrorCode("XTDE0030");
                e.setLocation(this.getLocation());
                throw e;
            }
        }
        if (vec == null) {
            vec = new ArrayList(1);
            vec.add(value);
        }
        if (this.formatter == null) {
            nf = new NumberFormatter();
            nf.prepare(this.formatOp.getChildExpression().evaluateAsString(context).toString());
        } else {
            nf = this.formatter;
        }
        CharSequence s = nf.format(vec, gpsize, gpseparator, letterVal, ordinalVal, numb);
        return new StringValue(s);
    }

    public List<Integer> parseStartAtValue(String value) throws XPathException {
        String[] tokens;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String tok : tokens = value.split("\\s+")) {
            try {
                int n = Integer.parseInt(tok);
                list.add(n);
            }
            catch (NumberFormatException err) {
                XPathException e = new XPathException("Invalid start-at value: non-integer component {" + tok + "}");
                e.setErrorCode("XTDE0030");
                e.setLocation(this.getLocation());
                throw e;
            }
        }
        if (list.isEmpty()) {
            XPathException e = new XPathException("Invalid start-at value: no numeric components found");
            e.setErrorCode("XTDE0030");
            e.setLocation(this.getLocation());
            throw e;
        }
        return list;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("xslNumber", this);
        String flags = "";
        if (this.hasVariablesInPatterns) {
            flags = flags + "v";
        }
        if (this.backwardsCompatible) {
            flags = flags + "1";
        }
        if (!flags.isEmpty()) {
            out.emitAttribute("flags", flags);
        }
        if (this.valueOp == null) {
            out.emitAttribute("level", LEVEL_NAMES[this.level]);
        }
        if (this.count != null) {
            out.setChildRole("count");
            this.count.export(out);
        }
        if (this.from != null) {
            out.setChildRole("from");
            this.from.export(out);
        }
        if (this.selectOp != null) {
            out.setChildRole("select");
            this.selectOp.getChildExpression().export(out);
        }
        if (this.valueOp != null) {
            out.setChildRole("value");
            this.valueOp.getChildExpression().export(out);
        }
        if (this.formatOp != null) {
            out.setChildRole("format");
            this.formatOp.getChildExpression().export(out);
        }
        if (this.startAtOp != null) {
            out.setChildRole("startAt");
            this.startAtOp.getChildExpression().export(out);
        }
        if (this.langOp != null) {
            out.setChildRole("lang");
            this.langOp.getChildExpression().export(out);
        }
        if (this.ordinalOp != null) {
            out.setChildRole("ordinal");
            this.ordinalOp.getChildExpression().export(out);
        }
        if (this.groupSeparatorOp != null) {
            out.setChildRole("gpSep");
            this.groupSeparatorOp.getChildExpression().export(out);
        }
        if (this.groupSizeOp != null) {
            out.setChildRole("gpSize");
            this.groupSizeOp.getChildExpression().export(out);
        }
        out.endElement();
    }
}

