/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.scr;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.core.osgi.OsgiCamelContextPublisher;
import org.apache.camel.core.osgi.OsgiDefaultCamelContext;
import org.apache.camel.core.osgi.utils.BundleDelegatingClassLoader;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.ExplicitCamelContextNameStrategy;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ReflectionHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCamelRunner
implements Runnable {
    public static final int START_DELAY = 5000;
    public static final String PROPERTY_PREFIX = "camel.scr.properties.prefix";
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected CamelContext context;
    protected SimpleRegistry registry = new SimpleRegistry();
    protected boolean active;
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture starter;
    private volatile boolean activated;
    private volatile boolean started;

    public synchronized void activate(BundleContext bundleContext, Map<String, String> props) throws Exception {
        if (this.activated) {
            return;
        }
        this.log.debug("activated!");
        this.activated = true;
        this.prepare(bundleContext, props);
        this.runWithDelay(this);
    }

    public synchronized void prepare(BundleContext bundleContext, Map<String, String> props) throws Exception {
        this.createCamelContext(bundleContext, props);
        AbstractCamelRunner.configure(this.context, this, this.log, true);
        this.setupCamelContext(bundleContext);
    }

    protected void createCamelContext(BundleContext bundleContext, Map<String, String> props) {
        if (null != bundleContext) {
            this.context = new OsgiDefaultCamelContext(bundleContext, (Registry)this.registry);
            this.context.setApplicationContextClassLoader((ClassLoader)new BundleDelegatingClassLoader(bundleContext.getBundle()));
            Thread.currentThread().setContextClassLoader(this.context.getApplicationContextClassLoader());
        } else {
            this.context = new DefaultCamelContext((Registry)this.registry);
        }
        AbstractCamelRunner.setupPropertiesComponent(this.context, props, this.log);
        String name = props.remove("camelContextId");
        if (name != null) {
            this.context.setNameStrategy((CamelContextNameStrategy)new ExplicitCamelContextNameStrategy(name));
        }
        this.context.getManagementStrategy().addEventNotifier((EventNotifier)new OsgiCamelContextPublisher(bundleContext));
    }

    protected void setupCamelContext(BundleContext bundleContext) throws Exception {
        this.context.setUseMDCLogging(Boolean.valueOf(true));
        this.context.setUseBreadcrumb(Boolean.valueOf(true));
        for (RoutesBuilder route : this.getRouteBuilders()) {
            this.context.addRoutes(AbstractCamelRunner.configure(this.context, route, this.log));
        }
    }

    public static void setupPropertiesComponent(CamelContext context, Map<String, String> props, Logger log) {
        PropertiesComponent pc = new PropertiesComponent();
        if (context.getComponentNames().contains("properties")) {
            pc = (PropertiesComponent)context.getComponent("properties", PropertiesComponent.class);
        } else {
            context.addComponent("properties", (Component)pc);
        }
        if (null != System.getProperty(PROPERTY_PREFIX)) {
            pc.setPropertyPrefix(System.getProperty(PROPERTY_PREFIX) + ".");
        }
        if (null != props) {
            Properties initialProps = new Properties();
            initialProps.putAll(props);
            log.debug(String.format("Added %d initial properties", props.size()));
            try {
                pc.setInitialProperties(initialProps);
            }
            catch (NoSuchMethodError e) {
                pc.setOverrideProperties(initialProps);
                pc.setLocation("default.properties");
            }
        }
    }

    protected abstract List<RoutesBuilder> getRouteBuilders();

    private void runWithDelay(Runnable runnable) {
        if (this.activated && !this.started) {
            this.cancelDelayedRun();
            this.starter = this.executor.schedule(runnable, 5000L, TimeUnit.MILLISECONDS);
        }
    }

    private void cancelDelayedRun() {
        if (null != this.starter) {
            this.starter.cancel(false);
        }
    }

    @Override
    public synchronized void run() {
        this.startCamelContext();
    }

    public synchronized void deactivate() {
        if (!this.activated) {
            return;
        }
        this.log.debug("deactivated!");
        this.activated = false;
        this.cancelDelayedRun();
        this.stop();
    }

    public synchronized void stop() {
        this.stopCamelContext();
    }

    private void startCamelContext() {
        if (this.started) {
            return;
        }
        try {
            if (!this.active) {
                this.context.setAutoStartup(Boolean.valueOf(false));
            }
            this.context.start();
            this.started = true;
        }
        catch (Exception e) {
            this.log.warn("Failed to start Camel context. Will try again when more Camel components have been registered.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopCamelContext() {
        if (!this.started) {
            return;
        }
        try {
            this.context.stop();
        }
        catch (Exception e) {
            this.log.error("Failed to stop Camel context.", (Throwable)e);
        }
        finally {
            this.started = false;
        }
    }

    public CamelContext getContext() {
        return this.context;
    }

    protected void gotCamelComponent(ServiceReference serviceReference) {
        this.log.trace("Got a new Camel Component.");
        this.runWithDelay(this);
    }

    protected void lostCamelComponent(ServiceReference serviceReference) {
        this.log.trace("Lost a Camel Component.");
    }

    public static <T> T configure(CamelContext context, T target, Logger log) {
        return AbstractCamelRunner.configure(context, target, log, false);
    }

    public static <T> T configure(CamelContext context, T target, Logger log, boolean deep) {
        Class<?> clazz = target.getClass();
        log.debug("Configuring {}", (Object)clazz.getName());
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (deep) {
            fields.addAll(Arrays.asList(clazz.getFields()));
            fields.addAll(Arrays.asList(clazz.getSuperclass().getDeclaredFields()));
        }
        for (Field field : fields) {
            String propertyValue;
            try {
                propertyValue = context.resolvePropertyPlaceholders("{{" + field.getName() + "}}");
            }
            catch (Exception e) {
                log.debug("Skipped field {}", (Object)field.getName());
                continue;
            }
            try {
                if (propertyValue.isEmpty()) continue;
                Object convertedValue = AbstractCamelRunner.convertValue(propertyValue, field.getGenericType());
                ReflectionHelper.setField((Field)field, target, (Object)convertedValue);
                log.debug("Configured field {} with value {}", (Object)field.getName(), (Object)propertyValue);
            }
            catch (Exception e) {
                log.error("Error setting field " + field.getName() + " due: " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
            }
        }
        return target;
    }

    public static Object convertValue(String value, Type type) throws Exception {
        Class clazz = null;
        if (type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        } else if (type instanceof Class) {
            clazz = (Class)type;
        }
        if (null != value) {
            if (clazz.isInstance(value)) {
                return value;
            }
            if (clazz == String.class) {
                return value;
            }
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                return Boolean.parseBoolean(value);
            }
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return Integer.parseInt(value);
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                return Long.parseLong(value);
            }
            if (clazz == Double.class || clazz == Double.TYPE) {
                return Double.parseDouble(value);
            }
            if (clazz == File.class) {
                return new File(value);
            }
            if (clazz == URI.class) {
                return new URI(value);
            }
            if (clazz == URL.class) {
                return new URL(value);
            }
            throw new IllegalArgumentException("Unsupported type: " + (clazz != null ? clazz.getName() : null));
        }
        return null;
    }
}

