/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.service;

import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.StartupListener;
import org.apache.camel.SuspendableService;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.component.service.ServiceEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed Service Consumer")
public class ServiceConsumer
extends DefaultConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(ServiceConsumer.class);
    private final ServiceRegistry serviceRegistry;
    private final Endpoint delegatedEndpoint;
    private final Processor processor;
    private Consumer delegatedConsumer;

    public ServiceConsumer(ServiceEndpoint serviceEndpoint, Processor processor, ServiceRegistry serviceRegistry) {
        super(serviceEndpoint, processor);
        this.serviceRegistry = serviceRegistry;
        this.delegatedEndpoint = serviceEndpoint.getEndpoint();
        this.processor = processor;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ServiceEndpoint endpoint = (ServiceEndpoint)this.getEndpoint();
        ServiceDefinition definition = endpoint.getServiceDefinition();
        LOG.debug("Using ServiceRegistry instance {} (id={}, type={}) to register: {}", new Object[]{this.serviceRegistry, this.serviceRegistry.getId(), this.serviceRegistry.getClass().getName(), definition});
        this.serviceRegistry.register(definition);
        this.delegatedConsumer = this.delegatedEndpoint.createConsumer(this.processor);
        if (this.delegatedConsumer instanceof StartupListener) {
            this.getEndpoint().getCamelContext().addStartupListener((StartupListener)((Object)this.delegatedConsumer));
        }
        ServiceHelper.startService((Object)this.delegatedEndpoint);
        ServiceHelper.startService((Object)this.delegatedConsumer);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceEndpoint endpoint = (ServiceEndpoint)this.getEndpoint();
        ServiceDefinition definition = endpoint.getServiceDefinition();
        this.serviceRegistry.deregister(definition);
        ServiceHelper.stopAndShutdownServices(this.delegatedConsumer);
        ServiceHelper.stopAndShutdownServices(this.delegatedEndpoint);
        this.delegatedConsumer = null;
    }

    @Override
    protected void doResume() throws Exception {
        if (this.delegatedConsumer instanceof SuspendableService) {
            ServiceEndpoint endpoint = (ServiceEndpoint)this.getEndpoint();
            ServiceDefinition definition = endpoint.getServiceDefinition();
            this.serviceRegistry.register(definition);
            ((SuspendableService)((Object)this.delegatedConsumer)).resume();
        }
        super.doResume();
    }

    @Override
    protected void doSuspend() throws Exception {
        if (this.delegatedConsumer instanceof SuspendableService) {
            ServiceEndpoint endpoint = (ServiceEndpoint)this.getEndpoint();
            ServiceDefinition definition = endpoint.getServiceDefinition();
            this.serviceRegistry.deregister(definition);
            ((SuspendableService)((Object)this.delegatedConsumer)).suspend();
        }
        super.doSuspend();
    }
}

