/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.servicenow.ServiceNowClient;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.ServiceNowDispatcher;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowHelper;
import org.apache.camel.component.servicenow.ServiceNowParam;
import org.apache.camel.component.servicenow.ServiceNowParams;
import org.apache.camel.util.ObjectHelper;

public abstract class AbstractServiceNowProcessor
implements Processor {
    protected final ServiceNowEndpoint endpoint;
    protected final ServiceNowConfiguration config;
    protected final ObjectMapper mapper;
    protected final ServiceNowClient client;
    private final JavaTypeCache javaTypeCache = new JavaTypeCache();
    private final List<ServiceNowDispatcher> dispatchers;

    protected AbstractServiceNowProcessor(ServiceNowEndpoint endpoint) {
        this.endpoint = endpoint;
        this.config = endpoint.getConfiguration();
        this.mapper = this.config.getOrCreateMapper();
        this.client = new ServiceNowClient(endpoint.getCamelContext(), this.config);
        this.dispatchers = new ArrayList<ServiceNowDispatcher>();
    }

    protected AbstractServiceNowProcessor setBodyAndHeaders(Message message, Class<?> responseModel, Response response) throws Exception {
        if (response != null) {
            this.setHeaders(message, responseModel, response);
            this.setBody(message, responseModel, response);
        }
        return this;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        ServiceNowDispatcher dispatcher = this.findDispatcher(exchange);
        if (dispatcher == null) {
            throw new IllegalArgumentException("Unable to process exchange");
        }
        dispatcher.process(exchange);
    }

    protected AbstractServiceNowProcessor setHeaders(Message message, Class<?> responseModel, Response response) throws Exception {
        ServiceNowHelper.findOffsets(response, (k, v) -> message.setHeader((String)k, v));
        String attachmentMeta = response.getHeaderString("X-Attachment-Metadata");
        if (ObjectHelper.isNotEmpty(attachmentMeta)) {
            message.setHeader("CamelServiceNowContentMeta", this.mapper.readValue(attachmentMeta, Map.class));
        }
        this.copyHeader(response, "Content-Type", message, "CamelServiceNowContentType");
        this.copyHeader(response, "Content-Encoding", message, "CamelServiceNowContentEncoding");
        if (responseModel != null) {
            message.getHeaders().putIfAbsent("CamelServiceNowModel", responseModel.getName());
            message.getHeaders().putIfAbsent("CamelServiceNowResponseModel", responseModel.getName());
        }
        return this;
    }

    protected AbstractServiceNowProcessor setBody(Message message, Class<?> model, Response response) throws Exception {
        if (message != null && response != null && ObjectHelper.isNotEmpty(response.getHeaderString("Content-Type"))) {
            JsonNode root = response.readEntity(JsonNode.class);
            HashMap<String, String> responseAttributes = null;
            if (root != null) {
                Iterator<Map.Entry<String, JsonNode>> fields = root.fields();
                while (fields.hasNext()) {
                    Map.Entry<String, JsonNode> entry = fields.next();
                    String key = entry.getKey();
                    JsonNode node = entry.getValue();
                    if (ObjectHelper.equal("result", key, true)) {
                        Object body = this.unwrap(node, model);
                        if (body == null) continue;
                        message.setHeader("CamelServiceNowResponseType", body.getClass());
                        message.setBody(body);
                        continue;
                    }
                    if (responseAttributes == null) {
                        responseAttributes = new HashMap<String, String>();
                    }
                    responseAttributes.put(key, node.textValue());
                }
                if (responseAttributes != null) {
                    message.setHeader("CamelServiceNowResponseMeta", responseAttributes);
                }
            }
        }
        return this;
    }

    protected AbstractServiceNowProcessor validateBody(Message message, Class<?> model) {
        return this.validateBody(message.getBody(), model);
    }

    protected AbstractServiceNowProcessor validateBody(Object body, Class<?> model) {
        ObjectHelper.notNull(body, "body");
        if (!body.getClass().isAssignableFrom(model)) {
            throw new IllegalArgumentException("Body is not compatible with model (body=" + body.getClass() + ", model=" + model);
        }
        return this;
    }

    protected Object unwrap(JsonNode node, Class<?> model) throws IOException {
        if (model == String.class) {
            return this.mapper.writeValueAsString(node);
        }
        Object result = node.isArray() ? (model.isInstance(Map.class) ? this.mapper.treeToValue((TreeNode)node, List.class) : this.mapper.readValue(node.traverse(), (JavaType)this.javaTypeCache.get(model))) : this.mapper.treeToValue((TreeNode)node, model);
        return result;
    }

    protected final void addDispatcher(ServiceNowDispatcher dispatcher) {
        this.dispatchers.add(dispatcher);
    }

    protected final void addDispatcher(String action, Processor processor) {
        this.addDispatcher(ServiceNowDispatcher.on(action, null, processor));
    }

    protected final void addDispatcher(String action, String subject, Processor processor) {
        this.addDispatcher(ServiceNowDispatcher.on(action, subject, processor));
    }

    protected final ServiceNowDispatcher findDispatcher(Exchange exchange) {
        ServiceNowDispatcher dispatcher = null;
        for (int i = 0; i < this.dispatchers.size(); ++i) {
            dispatcher = this.dispatchers.get(i);
            if (!dispatcher.match(exchange)) continue;
            return dispatcher;
        }
        return null;
    }

    protected Object getRequestParamFromHeader(ServiceNowParam sysParam, Message message) {
        return message.getHeader(sysParam.getHeader(), sysParam.getDefaultValue(this.config), sysParam.getType());
    }

    protected Object getMandatoryRequestParamFromHeader(ServiceNowParam sysParam, Message message) {
        return ObjectHelper.notNull(this.getRequestParamFromHeader(sysParam, message), sysParam.getHeader());
    }

    protected void copyHeader(Response from, String fromId, Message to, String toId) {
        Object fromValue = from.getHeaders().getFirst(fromId);
        if (ObjectHelper.isNotEmpty(fromValue)) {
            to.setHeader(toId, fromValue);
        }
    }

    protected Class<?> getRequestModel(Message message) {
        return this.getRequestModel(message, null);
    }

    protected Class<?> getRequestModel(Message message, String modelName) {
        Class model = null;
        if (message != null && (model = message.getHeader("CamelServiceNowRequestModel", Class.class)) == null) {
            model = message.getHeader("CamelServiceNowModel", Class.class);
        }
        return model != null ? model : (ObjectHelper.isEmpty(modelName) ? Map.class : this.config.getRequestModel(modelName, Map.class));
    }

    protected Class<?> getResponseModel(Message message) {
        return this.getRequestModel(message, null);
    }

    protected Class<?> getResponseModel(Message message, String modelName) {
        Class model = null;
        if (message != null && (model = message.getHeader("CamelServiceNowResponseModel", Class.class)) == null) {
            model = message.getHeader("CamelServiceNowModel", Class.class);
        }
        return model != null ? model : (ObjectHelper.isEmpty(modelName) ? Map.class : this.config.getResponseModel(modelName, Map.class));
    }

    protected String getApiVersion(Message message) {
        return message.getHeader("CamelServiceNowApiVersion", this.config.getApiVersion(), String.class);
    }

    protected String getTableName(Message message) {
        return message.getHeader(ServiceNowParams.PARAM_TABLE_NAME.getHeader(), this.config.getTable(), String.class);
    }

    protected String getSysID(Message message) {
        return message.getHeader(ServiceNowParams.PARAM_SYS_ID.getHeader(), String.class);
    }

    private class JavaTypeCache
    extends ClassValue<JavaType> {
        private JavaTypeCache() {
        }

        @Override
        protected JavaType computeValue(Class<?> type) {
            return AbstractServiceNowProcessor.this.mapper.getTypeFactory().constructCollectionType(List.class, type);
        }
    }
}

