/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.servicenow.ServiceNowComponentVerifierExtension;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowMetaDataExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;

@Metadata(label="verifiers", enums="parameters,connectivity")
@Component(value="servicenow")
public class ServiceNowComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata(label="advanced")
    private String instanceName;
    @Metadata
    private ServiceNowConfiguration configuration = new ServiceNowConfiguration();
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public ServiceNowComponent() {
        this(null);
    }

    public ServiceNowComponent(CamelContext camelContext) {
        super(camelContext);
        this.registerExtension(ServiceNowComponentVerifierExtension::new);
        this.registerExtension(ServiceNowMetaDataExtension::new);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public ServiceNowConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ServiceNowConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    @Override
    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public ComponentVerifierExtension getVerifier() {
        return (scope, parameters) -> this.getExtension(ComponentVerifierExtension.class).orElseThrow(UnsupportedOperationException::new).verify(scope, parameters);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CamelContext context = this.getCamelContext();
        ServiceNowConfiguration configuration = this.configuration.copy();
        Map<String, Object> models = PropertiesHelper.extractProperties(parameters, "model.");
        for (Map.Entry<String, Object> entry : models.entrySet()) {
            configuration.addModel(entry.getKey(), EndpointHelper.resolveParameter(context, (String)entry.getValue(), Class.class));
        }
        Map<String, Object> requestModels = PropertiesHelper.extractProperties(parameters, "requestModel.");
        for (Map.Entry<String, Object> entry : requestModels.entrySet()) {
            configuration.addRequestModel(entry.getKey(), EndpointHelper.resolveParameter(context, (String)entry.getValue(), Class.class));
        }
        Map<String, Object> map = PropertiesHelper.extractProperties(parameters, "responseModel.");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            configuration.addResponseModel(entry.getKey(), EndpointHelper.resolveParameter(context, (String)entry.getValue(), Class.class));
        }
        if (ObjectHelper.isEmpty(remaining)) {
            remaining = this.instanceName;
        }
        String string = this.getCamelContext().resolvePropertyPlaceholders(remaining);
        ServiceNowEndpoint serviceNowEndpoint = new ServiceNowEndpoint(uri, this, configuration, string);
        this.setProperties(serviceNowEndpoint, parameters);
        if (!configuration.hasApiUrl()) {
            configuration.setApiUrl(String.format("https://%s.service-now.com/api", string));
        }
        if (!configuration.hasOauthTokenUrl()) {
            configuration.setOauthTokenUrl(String.format("https://%s.service-now.com/oauth_token.do", string));
        }
        if (configuration.getSslContextParameters() == null) {
            configuration.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return serviceNowEndpoint;
    }
}

