/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.NoSuchOptionException;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.servicenow.ServiceNowClient;
import org.apache.camel.component.servicenow.ServiceNowComponent;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.ServiceNowException;
import org.apache.camel.component.servicenow.ServiceNowParams;
import org.apache.camel.util.ObjectHelper;

final class ServiceNowComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    ServiceNowComponentVerifierExtension() {
        super("servicenow");
    }

    @Override
    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.PARAMETERS);
        super.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    @Override
    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.CONNECTIVITY);
        try {
            ServiceNowConfiguration configuration = this.getServiceNowConfiguration(parameters);
            ServiceNowClient client = this.getServiceNowClient(configuration, parameters);
            String tableName = ObjectHelper.supplyIfEmpty(configuration.getTable(), () -> "incident");
            client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(configuration.getApiVersion()).path("table").path(tableName).query(ServiceNowParams.SYSPARM_LIMIT.getId(), 1L).query(ServiceNowParams.SYSPARM_FIELDS.getId(), "sys_id").invoke("GET");
        }
        catch (NoSuchOptionException e) {
            builder.error(ResultErrorBuilder.withMissingOption(e.getOptionName()).build());
        }
        catch (ServiceNowException e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withException(e).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_CODE, (Object)e.getCode()).detail("servicenow_error_message", (Object)e.getMessage()).detail("servicenow_error_status", (Object)e.getStatus()).detail("servicenow_error_detail", (Object)e.getDetail());
            if (e.getCode() == 401) {
                errorBuilder.code(ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION);
                errorBuilder.parameterKey("userName");
                errorBuilder.parameterKey("password");
                errorBuilder.parameterKey("oauthClientId");
                errorBuilder.parameterKey("oauthClientSecret");
            }
            builder.error(errorBuilder.build());
        }
        catch (Exception e) {
            builder.error(ResultErrorBuilder.withException(e).build());
        }
        return builder.build();
    }

    private String getInstanceName(Map<String, Object> parameters) throws Exception {
        String instanceName = (String)parameters.get("instanceName");
        if (ObjectHelper.isEmpty(instanceName) && ObjectHelper.isNotEmpty(this.getComponent())) {
            instanceName = this.getComponent(ServiceNowComponent.class).getInstanceName();
        }
        if (ObjectHelper.isEmpty(instanceName)) {
            throw new NoSuchOptionException("instanceName");
        }
        return instanceName;
    }

    private ServiceNowClient getServiceNowClient(ServiceNowConfiguration configuration, Map<String, Object> parameters) throws Exception {
        ServiceNowClient client = null;
        for (Object value : parameters.values()) {
            if (!(value instanceof ServiceNowClient)) continue;
            client = (ServiceNowClient)ServiceNowClient.class.cast(value);
            break;
        }
        if (ObjectHelper.isEmpty(client)) {
            String instanceName = this.getInstanceName(parameters);
            if (!configuration.hasApiUrl()) {
                configuration.setApiUrl(String.format("https://%s.service-now.com/api", instanceName));
            }
            if (!configuration.hasOauthTokenUrl()) {
                configuration.setOauthTokenUrl(String.format("https://%s.service-now.com/oauth_token.do", instanceName));
            }
            client = new ServiceNowClient(this.getCamelContext(), configuration);
        }
        return client;
    }

    private ServiceNowConfiguration getServiceNowConfiguration(Map<String, Object> parameters) throws Exception {
        ServiceNowConfiguration configuration = null;
        for (Object value : parameters.values()) {
            if (!(value instanceof ServiceNowConfiguration)) continue;
            configuration = (ServiceNowConfiguration)ServiceNowConfiguration.class.cast(value);
            break;
        }
        if (ObjectHelper.isEmpty(configuration)) {
            configuration = ObjectHelper.isNotEmpty(this.getComponent()) ? this.getComponent(ServiceNowComponent.class).getConfiguration().copy() : new ServiceNowConfiguration();
            this.setProperties(configuration, parameters);
        }
        return configuration;
    }
}

