/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.servicenow.ServiceNowRelease;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

@UriParams
public class ServiceNowConfiguration
implements Cloneable {
    @UriParam(label="security", secret=true)
    @Metadata(required=true)
    private String userName;
    @UriParam(label="security", secret=true)
    @Metadata(required=true)
    private String password;
    @UriParam(label="security", secret=true)
    private String oauthClientId;
    @UriParam(label="security", secret=true)
    private String oauthClientSecret;
    @UriParam(label="security", secret=true)
    private String oauthTokenUrl;
    @UriParam(label="security")
    private String apiUrl;
    @UriParam(label="advanced")
    private String apiVersion;
    @UriParam
    private String resource;
    @UriParam
    private String table;
    @UriParam
    private Boolean excludeReferenceLink = false;
    @UriParam
    private Boolean suppressAutoSysField = false;
    @UriParam
    private Boolean includeScores = false;
    @UriParam
    private Boolean includeAggregates = false;
    @UriParam
    private Boolean includeAvailableBreakdowns = false;
    @UriParam
    private Boolean includeAvailableAggregates = false;
    @UriParam
    private Boolean includeScoreNotes = false;
    @UriParam
    private Boolean topLevelOnly;
    @UriParam
    private Boolean favorites;
    @UriParam(label="advanced", defaultValue="false")
    private Boolean retrieveTargetRecordOnImport = false;
    @UriParam
    private Boolean key;
    @UriParam
    private Boolean target;
    @UriParam(defaultValue="true", enums="false,true,all")
    private String display = "true";
    @UriParam(defaultValue="10")
    private Integer perPage = 10;
    @UriParam(enums="value,change,changeperc,gap,gapperc,duedate,name,order,default,group,indicator_group,frequency,target,date,trend,bullet,direction")
    private String sortBy;
    @UriParam(enums="asc,desc")
    private String sortDir;
    @UriParam
    private Boolean suppressPaginationHeader = false;
    @UriParam(defaultValue="false", enums="false,true,all")
    private String displayValue = "false";
    @UriParam
    private Boolean inputDisplayValue = false;
    @UriParam(prefix="model.", multiValue=true, description="Defines both request and response models")
    private transient Map<String, Class<?>> models;
    @UriParam(prefix="request-model.", multiValue=true)
    private Map<String, Class<?>> requestModels;
    @UriParam(prefix="response-model.", multiValue=true)
    private Map<String, Class<?>> responseModels;
    @UriParam(label="advanced")
    private ObjectMapper mapper;
    @UriParam(defaultValue="HELSINKI", enums="FUJI,GENEVA,HELSINKI")
    private ServiceNowRelease release = ServiceNowRelease.HELSINKI;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="advanced")
    private HTTPClientPolicy httpClientPolicy;
    @UriParam(label="advanced")
    private ProxyAuthorizationPolicy proxyAuthorizationPolicy;
    @UriParam(label="proxy")
    private String proxyHost;
    @UriParam(label="proxy")
    private Integer proxyPort;
    @UriParam(label="proxy,security")
    private String proxyUserName;
    @UriParam(label="proxy,security")
    private String proxyPassword;
    @UriParam(label="advanced", defaultValue="yyyy-MM-dd")
    private String dateFormat = "yyyy-MM-dd";
    @UriParam(label="advanced", defaultValue="HH:mm:ss")
    private String timeFormat = "HH:mm:ss";
    @UriParam(label="advanced", defaultValue="yyyy-MM-dd HH:mm:ss")
    private String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";

    public String getUserName() {
        return this.userName;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public boolean hasApiUrl() {
        return this.apiUrl != null;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOauthClientId() {
        return this.oauthClientId;
    }

    public void setOauthClientId(String oauthClientId) {
        this.oauthClientId = oauthClientId;
    }

    public String getOauthClientSecret() {
        return this.oauthClientSecret;
    }

    public void setOauthClientSecret(String oauthClientSecret) {
        this.oauthClientSecret = oauthClientSecret;
    }

    public String getOauthTokenUrl() {
        return this.oauthTokenUrl;
    }

    public boolean hasOauthTokenUrl() {
        return this.oauthTokenUrl != null;
    }

    public void setOauthTokenUrl(String oauthTokenUrl) {
        this.oauthTokenUrl = oauthTokenUrl;
    }

    public boolean hasBasicAuthentication() {
        return ObjectHelper.isNotEmpty(this.userName) && ObjectHelper.isNotEmpty(this.password);
    }

    public boolean hasOAuthAuthentication() {
        return ObjectHelper.isNotEmpty(this.userName) && ObjectHelper.isNotEmpty(this.password) && ObjectHelper.isNotEmpty(this.oauthClientId) && ObjectHelper.isNotEmpty(this.oauthClientSecret);
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public Boolean getExcludeReferenceLink() {
        return this.excludeReferenceLink;
    }

    public void setExcludeReferenceLink(Boolean excludeReferenceLink) {
        this.excludeReferenceLink = excludeReferenceLink;
    }

    public Boolean getSuppressAutoSysField() {
        return this.suppressAutoSysField;
    }

    public void setSuppressAutoSysField(Boolean suppressAutoSysField) {
        this.suppressAutoSysField = suppressAutoSysField;
    }

    public Boolean getSuppressPaginationHeader() {
        return this.suppressPaginationHeader;
    }

    public void setSuppressPaginationHeader(Boolean suppressPaginationHeader) {
        this.suppressPaginationHeader = suppressPaginationHeader;
    }

    public Boolean getIncludeScores() {
        return this.includeScores;
    }

    public void setIncludeScores(Boolean includeScores) {
        this.includeScores = includeScores;
    }

    public Boolean getIncludeAggregates() {
        return this.includeAggregates;
    }

    public void setIncludeAggregates(Boolean includeAggregates) {
        this.includeAggregates = includeAggregates;
    }

    public Boolean getIncludeAvailableBreakdowns() {
        return this.includeAvailableBreakdowns;
    }

    public void setIncludeAvailableBreakdowns(Boolean includeAvailableBreakdowns) {
        this.includeAvailableBreakdowns = includeAvailableBreakdowns;
    }

    public Boolean getIncludeAvailableAggregates() {
        return this.includeAvailableAggregates;
    }

    public void setIncludeAvailableAggregates(Boolean includeAvailableAggregates) {
        this.includeAvailableAggregates = includeAvailableAggregates;
    }

    public Boolean getIncludeScoreNotes() {
        return this.includeScoreNotes;
    }

    public void setIncludeScoreNotes(Boolean includeScoreNotes) {
        this.includeScoreNotes = includeScoreNotes;
    }

    public Boolean getFavorites() {
        return this.favorites;
    }

    public void setFavorites(Boolean favorites) {
        this.favorites = favorites;
    }

    public Boolean getRetrieveTargetRecordOnImport() {
        return this.retrieveTargetRecordOnImport;
    }

    public void setRetrieveTargetRecordOnImport(Boolean retrieveTargetRecordOnImport) {
        this.retrieveTargetRecordOnImport = retrieveTargetRecordOnImport;
    }

    public Boolean getKey() {
        return this.key;
    }

    public void setKey(Boolean key) {
        this.key = key;
    }

    public Boolean getTarget() {
        return this.target;
    }

    public void setTarget(Boolean target) {
        this.target = target;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public Integer getPerPage() {
        return this.perPage;
    }

    public void setPerPage(Integer perPage) {
        this.perPage = perPage;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getSortDir() {
        return this.sortDir;
    }

    public void setSortDir(String sortDir) {
        this.sortDir = sortDir;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    public Boolean getInputDisplayValue() {
        return this.inputDisplayValue;
    }

    public void setInputDisplayValue(Boolean inputDisplayValue) {
        this.inputDisplayValue = inputDisplayValue;
    }

    public Map<String, Class<?>> getRequestModels() {
        return this.requestModels;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public ObjectMapper getOrCreateMapper() {
        if (this.mapper == null) {
            DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(this.getDateFormat());
            DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern(this.getTimeFormat());
            DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern(this.getDateTimeFormat());
            this.mapper = new ObjectMapper().registerModule(new Jdk8Module()).registerModule(new JavaTimeModule().addSerializer(LocalDate.class, new LocalDateSerializer(dateFormat)).addDeserializer(LocalDate.class, new LocalDateDeserializer(dateFormat)).addSerializer(LocalTime.class, new LocalTimeSerializer(timeFormat)).addDeserializer(LocalTime.class, new LocalTimeDeserializer(timeFormat)).addSerializer(LocalDateTime.class, new LocalDateTimeSerializer(dateTimeFormat)).addDeserializer(LocalDateTime.class, new LocalDateTimeDeserializer(dateTimeFormat))).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        return this.mapper;
    }

    public boolean hasMapper() {
        return this.mapper != null;
    }

    public void setRelease(ServiceNowRelease release) {
        this.release = release;
    }

    public ServiceNowRelease getRelease() {
        return this.release;
    }

    public Boolean getTopLevelOnly() {
        return this.topLevelOnly;
    }

    public void setTopLevelOnly(Boolean topLevelOnly) {
        this.topLevelOnly = topLevelOnly;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public HTTPClientPolicy getHttpClientPolicy() {
        return this.httpClientPolicy;
    }

    public void setHttpClientPolicy(HTTPClientPolicy httpClientPolicy) {
        this.httpClientPolicy = httpClientPolicy;
    }

    public ProxyAuthorizationPolicy getProxyAuthorizationPolicy() {
        return this.proxyAuthorizationPolicy;
    }

    public void setProxyAuthorizationPolicy(ProxyAuthorizationPolicy proxyAuthorizationPolicy) {
        this.proxyAuthorizationPolicy = proxyAuthorizationPolicy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public void setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public void setModels(Map<String, Class<?>> models) {
        this.setRequestModels(models);
        this.setResponseModels(models);
    }

    public Map<String, Class<?>> getModels() {
        return this.models;
    }

    public void addModel(String name, Class<?> type) {
        this.addRequestModel(name, type);
        this.addResponseModel(name, type);
    }

    public void setRequestModels(Map<String, Class<?>> models) {
        if (this.requestModels == null) {
            this.requestModels = new HashMap();
        }
        this.requestModels.clear();
        this.requestModels.putAll(models);
    }

    public Map<String, Class<?>> getResponseModels() {
        return this.responseModels;
    }

    public void addRequestModel(String name, Class<?> type) {
        if (this.requestModels == null) {
            this.requestModels = new HashMap();
        }
        this.requestModels.put(name, type);
    }

    public Class<?> getRequestModel(String name) {
        return this.getRequestModel(name, null);
    }

    public Class<?> getRequestModel(String name, Class<?> defaultType) {
        Class<?> model = defaultType;
        if (this.requestModels != null && this.requestModels.containsKey(name)) {
            model = this.requestModels.get(name);
        }
        return model;
    }

    public void setResponseModels(Map<String, Class<?>> models) {
        if (this.responseModels == null) {
            this.responseModels = new HashMap();
        }
        this.responseModels.putAll(models);
    }

    public void addResponseModel(String name, Class<?> type) {
        if (this.responseModels == null) {
            this.responseModels = new HashMap();
        }
        this.responseModels.clear();
        this.responseModels.put(name, type);
    }

    public Class<?> getResponseModel(String name) {
        return this.getResponseModel(name, null);
    }

    public Class<?> getResponseModel(String name, Class<?> defaultType) {
        Class<?> model = defaultType;
        if (this.responseModels != null && this.responseModels.containsKey(name)) {
            model = this.responseModels.get(name);
        }
        return model;
    }

    public ServiceNowConfiguration copy() {
        try {
            return (ServiceNowConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException(e);
        }
    }
}

