/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import java.util.function.Predicate;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.util.ObjectHelper;

public class ServiceNowDispatcher {
    private final Predicate<Exchange> predicate;
    private final Processor delegate;

    public ServiceNowDispatcher(Predicate<Exchange> predicate, Processor delegate) {
        this.predicate = ObjectHelper.notNull(predicate, "predicate");
        this.delegate = ObjectHelper.notNull(delegate, "delegate");
    }

    public boolean match(Exchange exchange) {
        return this.predicate.test(exchange);
    }

    public void process(Exchange exchange) throws Exception {
        this.delegate.process(exchange);
    }

    public static ServiceNowDispatcher on(String action, String subject, Processor delegate) {
        return new ServiceNowDispatcher(e -> ServiceNowDispatcher.matches(e.getIn(), action, subject), delegate);
    }

    public static boolean matches(Message in, String action, String subject) {
        return ObjectHelper.equal(action, in.getHeader("CamelServiceNowAction", String.class), true) && ObjectHelper.equal(subject, in.getHeader("CamelServiceNowActionSubject", String.class), true);
    }
}

