/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.releases.helsinki;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.AbstractServiceNowProcessor;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowParams;
import org.apache.camel.util.ObjectHelper;

class HelsinkiServiceNowServiceCatalogItemsProcessor
extends AbstractServiceNowProcessor {
    HelsinkiServiceNowServiceCatalogItemsProcessor(ServiceNowEndpoint endpoint) {
        super(endpoint);
        this.addDispatcher("retrieve", "submit_guide", this::submitItemGuide);
        this.addDispatcher("retrieve", "checkout_guide", this::checkoutItemGuide);
        this.addDispatcher("retrieve", this::retrieveItems);
        this.addDispatcher("create", "cart", this::addItemToCart);
        this.addDispatcher("create", "producer", this::submitItemProducer);
    }

    private void retrieveItems(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String sysId = this.getSysID(in);
        String apiVersion = this.getApiVersion(in);
        Response response = ObjectHelper.isEmpty(sysId) ? this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("servicecatalog").path("items").query(ServiceNowParams.SYSPARM_CATEGORY, in).query(ServiceNowParams.SYSPARM_TYPE, in).query(ServiceNowParams.SYSPARM_LIMIT, in).query(ServiceNowParams.SYSPARM_TEXT, in).query(ServiceNowParams.SYSPARM_OFFSET, in).query(ServiceNowParams.SYSPARM_CATALOG, in).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("GET") : this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("items").path("items").path(sysId).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("GET");
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void submitItemGuide(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String sysId = this.getSysID(in);
        String apiVersion = this.getApiVersion(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("servicecatalog").path("items").path(ObjectHelper.notNull(sysId, "sysId")).path("submit_guide").query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("POST", in.getMandatoryBody());
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void checkoutItemGuide(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String sysId = this.getSysID(in);
        String apiVersion = this.getApiVersion(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("servicecatalog").path("items").path(ObjectHelper.notNull(sysId, "sysId")).path("submit_guide").query(responseModel).invoke("POST", in.getMandatoryBody());
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void addItemToCart(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String sysId = this.getSysID(in);
        String apiVersion = this.getApiVersion(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("servicecatalog").path("items").path(ObjectHelper.notNull(sysId, "sysId")).path("add_to_cart").query(responseModel).invoke("POST");
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void submitItemProducer(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String sysId = this.getSysID(in);
        String apiVersion = this.getApiVersion(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("servicecatalog").path("items").path(ObjectHelper.notNull(sysId, "sysId")).path("submit_producer").query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("POST", in.getMandatoryBody());
        this.setBodyAndHeaders(in, responseModel, response);
    }
}

