/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.releases.helsinki;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.AbstractServiceNowProcessor;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowParams;
import org.apache.camel.util.ObjectHelper;

class HelsinkiServiceNowTableProcessor
extends AbstractServiceNowProcessor {
    HelsinkiServiceNowTableProcessor(ServiceNowEndpoint endpoint) {
        super(endpoint);
        this.addDispatcher("retrieve", this::retrieveRecord);
        this.addDispatcher("create", this::createRecord);
        this.addDispatcher("modify", this::modifyRecord);
        this.addDispatcher("delete", this::deleteRecord);
        this.addDispatcher("update", this::updateRecord);
    }

    private void retrieveRecord(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String tableName = this.getTableName(in);
        String apiVersion = this.getApiVersion(in);
        Class<?> responseModel = this.getResponseModel(in, tableName);
        String sysId = this.getSysID(in);
        Response response = ObjectHelper.isEmpty(sysId) ? this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("table").path(tableName).query(ServiceNowParams.SYSPARM_QUERY, in).query(ServiceNowParams.SYSPARM_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_EXCLUDE_REFERENCE_LINK, in).query(ServiceNowParams.SYSPARM_SUPPRESS_PAGINATION_HEADER, in).query(ServiceNowParams.SYSPARM_FIELDS, in).query(ServiceNowParams.SYSPARM_LIMIT, in).query(ServiceNowParams.SYSPARM_OFFSET, in).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("GET") : this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("table").path(tableName).path(sysId).query(ServiceNowParams.SYSPARM_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_EXCLUDE_REFERENCE_LINK, in).query(ServiceNowParams.SYSPARM_FIELDS, in).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("GET");
        this.setBodyAndHeaders(exchange.getIn(), responseModel, response);
    }

    private void createRecord(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String tableName = this.getTableName(in);
        String apiVersion = this.getApiVersion(in);
        Class<?> requestModel = this.getRequestModel(in, tableName);
        Class<?> responseModel = this.getResponseModel(in, tableName);
        this.validateBody(in, requestModel);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("table").path(tableName).query(ServiceNowParams.SYSPARM_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_EXCLUDE_REFERENCE_LINK, in).query(ServiceNowParams.SYSPARM_FIELDS, in).query(ServiceNowParams.SYSPARM_INPUT_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_SUPPRESS_AUTO_SYS_FIELD, in).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("POST", in.getMandatoryBody());
        this.setBodyAndHeaders(exchange.getIn(), responseModel, response);
    }

    private void modifyRecord(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String tableName = this.getTableName(in);
        String apiVersion = this.getApiVersion(in);
        Class<?> requestModel = this.getRequestModel(in, tableName);
        Class<?> responseModel = this.getResponseModel(in, tableName);
        String sysId = this.getSysID(in);
        this.validateBody(in, requestModel);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("table").path(tableName).path(ObjectHelper.notNull(sysId, "sysId")).query(ServiceNowParams.SYSPARM_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_EXCLUDE_REFERENCE_LINK, in).query(ServiceNowParams.SYSPARM_FIELDS, in).query(ServiceNowParams.SYSPARM_INPUT_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_SUPPRESS_AUTO_SYS_FIELD, in).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("PUT", in.getMandatoryBody());
        this.setBodyAndHeaders(exchange.getIn(), responseModel, response);
    }

    private void deleteRecord(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String tableName = this.getTableName(in);
        String apiVersion = this.getApiVersion(in);
        Class<?> responseModel = this.getResponseModel(in, tableName);
        String sysId = this.getSysID(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("table").path(tableName).path(ObjectHelper.notNull(sysId, "sysId")).query(responseModel).invoke("DELETE", null);
        this.setBodyAndHeaders(exchange.getIn(), responseModel, response);
    }

    private void updateRecord(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String tableName = this.getTableName(in);
        String apiVersion = this.getApiVersion(in);
        Class<?> requestModel = this.getRequestModel(in, tableName);
        Class<?> responseModel = this.getResponseModel(in, tableName);
        String sysId = this.getSysID(in);
        this.validateBody(in, requestModel);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("table").path(tableName).path(ObjectHelper.notNull(sysId, "sysId")).query(ServiceNowParams.SYSPARM_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_EXCLUDE_REFERENCE_LINK, in).query(ServiceNowParams.SYSPARM_FIELDS, in).query(ServiceNowParams.SYSPARM_INPUT_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_SUPPRESS_AUTO_SYS_FIELD, in).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("PATCH", in.getMandatoryBody());
        this.setBodyAndHeaders(exchange.getIn(), responseModel, response);
    }
}

