/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.LocalBeanRepositoryAware;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.SimpleRegistry;
import org.apache.camel.support.SupplierRegistry;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.function.Suppliers;

public class DefaultRegistry
extends ServiceSupport
implements Registry,
LocalBeanRepositoryAware,
CamelContextAware {
    protected CamelContext camelContext;
    protected final ThreadLocal<BeanRepository> localRepository = new ThreadLocal();
    protected volatile boolean localRepositoryEnabled;
    protected List<BeanRepository> repositories;
    protected Registry fallbackRegistry = new SimpleRegistry();
    protected Registry supplierRegistry = new SupplierRegistry();

    public DefaultRegistry() {
    }

    public DefaultRegistry(BeanRepository ... repositories) {
        if (repositories != null) {
            this.repositories = new ArrayList<BeanRepository>(Arrays.asList(repositories));
        }
    }

    public DefaultRegistry(Collection<BeanRepository> repositories) {
        if (repositories != null) {
            this.repositories = new ArrayList<BeanRepository>(repositories);
        }
    }

    @Override
    public void setLocalBeanRepository(BeanRepository repository) {
        if (repository != null) {
            this.localRepository.set(repository);
            this.localRepositoryEnabled = true;
        } else {
            BeanRepository old = this.localRepository.get();
            if (old != null) {
                ServiceHelper.stopService((Object)old);
            }
            this.localRepository.remove();
            this.localRepositoryEnabled = false;
        }
    }

    @Override
    public BeanRepository getLocalBeanRepository() {
        return this.localRepositoryEnabled ? this.localRepository.get() : null;
    }

    public Registry getFallbackRegistry() {
        return this.fallbackRegistry;
    }

    public void setFallbackRegistry(Registry fallbackRegistry) {
        this.fallbackRegistry = fallbackRegistry;
    }

    public Registry getSupplierRegistry() {
        return this.supplierRegistry;
    }

    public void setSupplierRegistry(Registry supplierRegistry) {
        this.supplierRegistry = supplierRegistry;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public List<BeanRepository> getRepositories() {
        if (this.repositories == null) {
            return null;
        }
        return Collections.unmodifiableList(this.repositories);
    }

    @Override
    public void bind(String id, Class<?> type, Object bean) throws RuntimeCamelException {
        if (bean != null) {
            CamelContextAware.trySetCamelContext(bean, this.camelContext);
            this.fallbackRegistry.bind(id, type, bean);
        }
    }

    @Override
    public void bind(String id, Class<?> type, Supplier<Object> bean) throws RuntimeCamelException {
        if (bean != null) {
            this.supplierRegistry.bind(id, type, Suppliers.memorize(bean));
        }
    }

    @Override
    public void bindAsPrototype(String id, Class<?> type, Supplier<Object> bean) throws RuntimeCamelException {
        if (bean != null) {
            this.supplierRegistry.bind(id, type, bean);
        }
    }

    @Override
    public void unbind(String id) {
        this.supplierRegistry.unbind(id);
        this.fallbackRegistry.unbind(id);
    }

    @Override
    public Object lookupByName(String name) {
        Object answer;
        BeanRepository local;
        try {
            if (this.camelContext != null && !name.equals("properties")) {
                name = this.camelContext.resolvePropertyPlaceholders(name);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        BeanRepository beanRepository = local = this.localRepositoryEnabled ? this.localRepository.get() : null;
        if (local != null && (answer = local.lookupByName(name)) != null) {
            return this.unwrap(answer);
        }
        if (this.repositories != null) {
            for (BeanRepository r : this.repositories) {
                answer = r.lookupByName(name);
                if (answer == null) continue;
                return this.unwrap(answer);
            }
        }
        if ((answer = this.supplierRegistry.lookupByName(name)) == null) {
            answer = this.fallbackRegistry.lookupByName(name);
        }
        if (answer != null) {
            answer = this.unwrap(answer);
        }
        return answer;
    }

    @Override
    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Object answer;
        BeanRepository local;
        try {
            if (this.camelContext != null && !name.equals("properties")) {
                name = this.camelContext.resolvePropertyPlaceholders(name);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        BeanRepository beanRepository = local = this.localRepositoryEnabled ? this.localRepository.get() : null;
        if (local != null && (answer = local.lookupByNameAndType(name, type)) != null) {
            return (T)this.unwrap(answer);
        }
        if (this.repositories != null) {
            for (BeanRepository r : this.repositories) {
                answer = r.lookupByNameAndType(name, type);
                if (answer == null) continue;
                return (T)this.unwrap(answer);
            }
        }
        if ((answer = this.supplierRegistry.lookupByNameAndType(name, type)) == null) {
            answer = this.fallbackRegistry.lookupByNameAndType(name, type);
        }
        if (answer != null) {
            answer = this.unwrap(answer);
        }
        return answer;
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        Map<String, T> found;
        BeanRepository local;
        LinkedHashMap<String, T> answer = new LinkedHashMap<String, T>();
        BeanRepository beanRepository = local = this.localRepositoryEnabled ? this.localRepository.get() : null;
        if (local != null && (found = local.findByTypeWithName(type)) != null && !found.isEmpty()) {
            answer.putAll(found);
        }
        if (this.repositories != null) {
            found = this.repositories.iterator();
            while (found.hasNext()) {
                BeanRepository r = (BeanRepository)found.next();
                Map<String, T> found2 = r.findByTypeWithName(type);
                if (found2 == null || found2.isEmpty()) continue;
                answer.putAll(found2);
            }
        }
        if ((found = this.supplierRegistry.findByTypeWithName(type)) != null && !found.isEmpty()) {
            answer.putAll(found);
        }
        if ((found = this.fallbackRegistry.findByTypeWithName(type)) != null && !found.isEmpty()) {
            answer.putAll(found);
        }
        return answer;
    }

    @Override
    public <T> Set<T> findByType(Class<T> type) {
        Set<T> found;
        BeanRepository local;
        LinkedHashSet<T> answer = new LinkedHashSet<T>();
        BeanRepository beanRepository = local = this.localRepositoryEnabled ? this.localRepository.get() : null;
        if (local != null && (found = local.findByType(type)) != null && !found.isEmpty()) {
            answer.addAll(found);
        }
        if (this.repositories != null) {
            found = this.repositories.iterator();
            while (found.hasNext()) {
                BeanRepository r = (BeanRepository)found.next();
                Set<T> found2 = r.findByType(type);
                if (found2 == null || found2.isEmpty()) continue;
                answer.addAll(found2);
            }
        }
        if ((found = this.supplierRegistry.findByType(type)) != null && !found.isEmpty()) {
            answer.addAll(found);
        }
        if ((found = this.fallbackRegistry.findByType(type)) != null && !found.isEmpty()) {
            answer.addAll(found);
        }
        return answer;
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.supplierRegistry instanceof Closeable) {
            IOHelper.close((Closeable)((Object)this.supplierRegistry));
        }
        if (this.fallbackRegistry instanceof Closeable) {
            IOHelper.close((Closeable)((Object)this.fallbackRegistry));
        }
        ServiceHelper.stopAndShutdownServices(this.supplierRegistry, this.fallbackRegistry);
    }
}

