/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.atom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.stream.XMLStreamReader;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.parser.ParserOptions;
import org.apache.abdera.writer.Writer;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.staxutils.StaxUtils;

public abstract class AbstractAtomProvider<T extends Element>
implements MessageBodyWriter<T>,
MessageBodyReader<T> {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractAtomProvider.class);
    private static final Abdera ATOM_ENGINE = new Abdera();
    private boolean autodetectCharset;
    private boolean formattedOutput;

    @Override
    public long getSize(T element, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    @Override
    public void writeTo(T element, Class<?> clazz, Type type, Annotation[] a, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        if (MediaType.APPLICATION_JSON_TYPE.isCompatible(mt)) {
            Writer w = this.createWriter("json");
            if (w == null) {
                throw ExceptionUtils.toNotSupportedException(null, null);
            }
            element.writeTo(w, os);
        } else if (this.formattedOutput) {
            Writer w = this.createWriter("prettyxml");
            if (w != null) {
                element.writeTo(w, os);
            } else {
                element.writeTo(os);
            }
        } else {
            element.writeTo(os);
        }
    }

    protected Writer createWriter(String writerName) {
        Writer w = ATOM_ENGINE.getWriterFactory().getWriter(writerName);
        if (w == null) {
            LOG.fine("Atom writer \"" + writerName + "\" is not available");
        }
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T readFrom(Class<T> clazz, Type t, Annotation[] a, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        Parser parser;
        Parser parser2 = parser = ATOM_ENGINE.getParser();
        synchronized (parser2) {
            ParserOptions options = parser.getDefaultParserOptions();
            if (options != null) {
                options.setAutodetectCharset(this.autodetectCharset);
            }
        }
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(is);
        Document doc = parser.parse(reader);
        return (T)doc.getRoot();
    }

    public void setFormattedOutput(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
    }

    public void setAutodetectCharset(boolean autodetectCharset) {
        this.autodetectCharset = autodetectCharset;
    }
}

