/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.jaxrs.JwtTokenSecurityContext;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtConsumer;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;
import org.apache.cxf.security.SecurityContext;

@PreMatching
@Priority(value=1000)
public abstract class AbstractJwtAuthenticationFilter
extends JoseJwtConsumer
implements ContainerRequestFilter {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractJwtAuthenticationFilter.class);
    private String roleClaim;
    private boolean validateAudience = true;

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        String encodedJwtToken = this.getEncodedJwtToken(requestContext);
        JwtToken token = super.getJwtToken(encodedJwtToken);
        SecurityContext securityContext = this.configureSecurityContext(token);
        if (securityContext != null) {
            JAXRSUtils.getCurrentMessage().put(SecurityContext.class, securityContext);
        }
    }

    protected abstract String getEncodedJwtToken(ContainerRequestContext var1);

    protected SecurityContext configureSecurityContext(JwtToken jwt) {
        Message m = JAXRSUtils.getCurrentMessage();
        boolean enableUnsignedJwt = MessageUtils.getContextualBoolean(m, "rs.security.enable.unsigned-jwt.principal", false);
        if (jwt.getClaims().getSubject() != null && (this.isVerifiedWithAPublicKey(jwt) || enableUnsignedJwt)) {
            return new JwtTokenSecurityContext(jwt, this.roleClaim);
        }
        return null;
    }

    private boolean isVerifiedWithAPublicKey(JwtToken jwt) {
        if (this.isJwsRequired()) {
            String alg = (String)jwt.getJwsHeader("alg");
            SignatureAlgorithm sigAlg = SignatureAlgorithm.getAlgorithm(alg);
            return SignatureAlgorithm.isPublicKeyAlgorithm(sigAlg);
        }
        return false;
    }

    @Override
    protected void validateToken(JwtToken jwt) {
        JwtUtils.validateTokenClaims(jwt.getClaims(), this.getTtl(), this.getClockOffset(), this.isValidateAudience());
    }

    public String getRoleClaim() {
        return this.roleClaim;
    }

    public void setRoleClaim(String roleClaim) {
        this.roleClaim = roleClaim;
    }

    public boolean isValidateAudience() {
        return this.validateAudience;
    }

    public void setValidateAudience(boolean validateAudience) {
        this.validateAudience = validateAudience;
    }
}

