/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Principal;
import javax.annotation.Priority;
import javax.security.auth.x500.X500Principal;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsReaderProvider;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.PublicKeyJwsSignatureVerifier;
import org.apache.cxf.security.SecurityContext;

@PreMatching
@Priority(value=1002)
public class JwsContainerRequestFilter
extends AbstractJwsReaderProvider
implements ContainerRequestFilter {
    @Override
    public void filter(ContainerRequestContext context) throws IOException {
        SecurityContext securityContext;
        Principal currentPrincipal;
        if (this.isMethodWithNoContent(context.getMethod()) || this.isCheckEmptyStream() && !context.hasEntity()) {
            return;
        }
        String content = IOUtils.readStringFromStream(context.getEntityStream());
        if (StringUtils.isEmpty(content)) {
            return;
        }
        JwsCompactConsumer p = new JwsCompactConsumer(content);
        JwsSignatureVerifier theSigVerifier = this.getInitializedSigVerifier(p.getJwsHeaders());
        if (!p.verifySignatureWith(theSigVerifier)) {
            context.abortWith(JAXRSUtils.toResponse(400));
            return;
        }
        JoseUtils.validateRequestContextProperty(p.getJwsHeaders());
        byte[] bytes = p.getDecodedJwsPayloadBytes();
        context.setEntityStream(new ByteArrayInputStream(bytes));
        context.getHeaders().putSingle("Content-Length", Integer.toString(bytes.length));
        String ct = JoseUtils.checkContentType(p.getJwsHeaders().getContentType(), this.getDefaultMediaType());
        if (ct != null) {
            context.getHeaders().putSingle("Content-Type", ct);
        }
        if (super.isValidateHttpHeaders()) {
            super.validateHttpHeadersIfNeeded(context.getHeaders(), p.getJwsHeaders());
        }
        if (((currentPrincipal = context.getSecurityContext().getUserPrincipal()) == null || currentPrincipal.getName() == null) && (securityContext = this.configureSecurityContext(theSigVerifier)) != null) {
            JAXRSUtils.getCurrentMessage().put(SecurityContext.class, securityContext);
        }
    }

    protected SecurityContext configureSecurityContext(JwsSignatureVerifier sigVerifier) {
        if (sigVerifier instanceof PublicKeyJwsSignatureVerifier && ((PublicKeyJwsSignatureVerifier)sigVerifier).getX509Certificate() != null) {
            final X500Principal principal = ((PublicKeyJwsSignatureVerifier)sigVerifier).getX509Certificate().getSubjectX500Principal();
            return new SecurityContext(){

                @Override
                public Principal getUserPrincipal() {
                    return principal;
                }

                @Override
                public boolean isUserInRole(String arg0) {
                    return false;
                }
            };
        }
        return null;
    }

    protected boolean isMethodWithNoContent(String method) {
        return "DELETE".equals(method) || HttpUtils.isMethodWithNoRequestContent(method);
    }
}

