/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwtAuthenticationFilter;

public class JwtCookieAuthenticationFilter
extends AbstractJwtAuthenticationFilter {
    private static final String DEFAULT_COOKIE_NAME = "access_token";
    private String cookieName = "access_token";

    @Override
    protected String getEncodedJwtToken(ContainerRequestContext requestContext) {
        Cookie cookie = requestContext.getCookies().get(this.cookieName);
        if (cookie == null || cookie.getValue() == null) {
            throw new JoseException("JWT cookie is not available");
        }
        return cookie.getValue();
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }
}

