/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs.multipart;

import java.io.OutputStream;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.cxf.attachment.ByteDataSource;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartOutputFilter;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsOutputStream;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;

public class JwsMultipartSignatureOutFilter
implements MultipartOutputFilter {
    private JwsSignature sig;

    public JwsMultipartSignatureOutFilter(JwsSignature sig) {
        this.sig = sig;
    }

    @Override
    public void filter(List<Attachment> parts) {
        for (int i = 0; i < parts.size() - 1; ++i) {
            Attachment dataPart = parts.get(i);
            DataHandler handler = dataPart.getDataHandler();
            dataPart.setDataHandler(new JwsSignatureDataHandler(handler));
        }
    }

    private class JwsSignatureDataHandler
    extends DataHandler {
        private DataHandler handler;

        JwsSignatureDataHandler(DataHandler handler) {
            super(new ByteDataSource("1".getBytes()));
            this.handler = handler;
        }

        @Override
        public String getContentType() {
            return this.handler.getContentType();
        }

        @Override
        public void writeTo(OutputStream os) {
            JwsOutputStream jwsOutStream = new JwsOutputStream(os, JwsMultipartSignatureOutFilter.this.sig, false);
            try {
                this.handler.writeTo(jwsOutStream);
                jwsOutStream.flush();
            }
            catch (Exception ex) {
                throw new JwsException(JwsException.Error.INVALID_SIGNATURE);
            }
        }
    }
}

