/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.services.AbstractAccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;

@Path(value="validate")
public class AccessTokenValidatorService
extends AbstractAccessTokenValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(AccessTokenValidatorService.class);
    private boolean blockUnsecureRequests;
    private boolean blockUnauthorizedRequests = true;

    @POST
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public AccessTokenValidation getTokenValidationInfo(@Encoded MultivaluedMap<String, String> params) {
        this.checkSecurityContext();
        String authScheme = params.getFirst("authScheme");
        String authSchemeData = params.getFirst("authSchemeData");
        try {
            return super.getAccessTokenValidation(authScheme, authSchemeData, params);
        }
        catch (NotAuthorizedException ex) {
            AccessTokenValidation v = new AccessTokenValidation();
            v.setInitialValidationSuccessful(false);
            return v;
        }
    }

    private void checkSecurityContext() {
        SecurityContext sc = this.getMessageContext().getSecurityContext();
        if (!sc.isSecure() && this.blockUnsecureRequests) {
            LOG.warning("Unsecure HTTP, Transport Layer Security is recommended");
            AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes, this.realm);
        }
        if (sc.getUserPrincipal() == null && this.blockUnauthorizedRequests) {
            LOG.warning("Authenticated Principal is not available");
            AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes, this.realm);
        }
    }

    public void setBlockUnsecureRequests(boolean blockUnsecureRequests) {
        this.blockUnsecureRequests = blockUnsecureRequests;
    }

    public void setBlockUnauthorizedRequests(boolean blockUnauthorizedRequests) {
        this.blockUnauthorizedRequests = blockUnauthorizedRequests;
    }
}

