/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.provider.SubjectCreator;
import org.apache.cxf.rs.security.oauth2.services.AbstractOAuthService;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.security.SecurityContext;

@Path(value="/authorize-direct")
public class DirectAuthorizationService
extends AbstractOAuthService {
    private SubjectCreator subjectCreator;
    private boolean partialMatchScopeValidation;
    private boolean useAllClientScopes;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public Response authorize(MultivaluedMap<String, String> params) {
        SecurityContext sc = this.getAndValidateSecurityContext(params);
        Client client = this.getClient(params);
        UserSubject userSubject = this.createUserSubject(sc, params);
        AccessTokenRegistration reg = new AccessTokenRegistration();
        reg.setClient(client);
        reg.setGrantType("urn:ietf:params:oauth:grant-type:direct-token-grant");
        reg.setSubject(userSubject);
        String providedScope = params.getFirst("scope");
        List<String> requestedScope = OAuthUtils.getRequestedScopes(client, providedScope, this.useAllClientScopes, this.partialMatchScopeValidation);
        reg.setRequestedScope(requestedScope);
        reg.setApprovedScope(requestedScope);
        ServerAccessToken token = this.getDataProvider().createAccessToken(reg);
        ClientAccessToken clientToken = OAuthUtils.toClientAccessToken(token, this.isWriteOptionalParameters());
        return Response.ok(clientToken).build();
    }

    protected SecurityContext getAndValidateSecurityContext(MultivaluedMap<String, String> params) {
        SecurityContext securityContext = (SecurityContext)this.getMessageContext().get(SecurityContext.class.getName());
        if (securityContext == null || securityContext.getUserPrincipal() == null) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        this.checkTransportSecurity();
        return securityContext;
    }

    protected UserSubject createUserSubject(SecurityContext securityContext, MultivaluedMap<String, String> params) {
        UserSubject subject;
        if (this.subjectCreator != null && (subject = this.subjectCreator.createUserSubject(this.getMessageContext(), params)) != null) {
            return subject;
        }
        subject = this.getMessageContext().getContent(UserSubject.class);
        if (subject != null) {
            return subject;
        }
        return OAuthUtils.createSubject(securityContext);
    }

    public SubjectCreator getSubjectCreator() {
        return this.subjectCreator;
    }

    public void setSubjectCreator(SubjectCreator subjectCreator) {
        this.subjectCreator = subjectCreator;
    }

    protected Client getClient(MultivaluedMap<String, String> params) {
        Client client;
        block3: {
            client = null;
            try {
                client = this.getValidClient(params.getFirst("client_id"), params);
            }
            catch (OAuthServiceException ex) {
                if (ex.getError() == null) break block3;
                this.reportInvalidRequestError(ex.getError(), null);
            }
        }
        if (client == null) {
            this.reportInvalidRequestError("Client ID is invalid", null);
        }
        return client;
    }

    public boolean isPartialMatchScopeValidation() {
        return this.partialMatchScopeValidation;
    }

    public void setPartialMatchScopeValidation(boolean partialMatchScopeValidation) {
        this.partialMatchScopeValidation = partialMatchScopeValidation;
    }

    public void setUseAllClientScopes(boolean useAllClientScopes) {
        this.useAllClientScopes = useAllClientScopes;
    }
}

