/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.servlet.DefaultHttpRegistry;
import org.apache.camel.component.servlet.HttpRegistry;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.converter.ObjectConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelHttpTransportServlet
extends CamelServlet {
    private static final long serialVersionUID = -1797014782158930490L;
    private static final Logger LOG = LoggerFactory.getLogger(CamelHttpTransportServlet.class);
    private HttpRegistry httpRegistry;
    private boolean ignoreDuplicateServletName;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String ignore = config.getInitParameter("ignoreDuplicateServletName");
        Boolean bool = ObjectConverter.toBoolean((String)ignore);
        if (bool == null) {
            String msg = "Invalid parameter value for init-parameter ignoreDuplicateServletName with value: " + ignore;
            LOG.error(msg);
            throw new ServletException(msg);
        }
        this.ignoreDuplicateServletName = bool;
        String name = config.getServletName();
        String contextPath = config.getServletContext().getContextPath();
        if (this.httpRegistry == null) {
            this.httpRegistry = DefaultHttpRegistry.getHttpRegistry(name);
            CamelServlet existing = this.httpRegistry.getCamelServlet(name);
            if (existing != null) {
                String msg = "Duplicate ServetName detected: " + name + ". Existing: " + (Object)((Object)existing) + " This: " + this.toString() + ". Its advised to use unique ServletName per Camel application.";
                if (this.isIgnoreDuplicateServletName()) {
                    LOG.warn(msg);
                } else {
                    LOG.error(msg);
                    throw new ServletException(msg);
                }
            }
            this.httpRegistry.register(this);
        }
        LOG.info("Initialized CamelHttpTransportServlet[name={}, contextPath={}]", (Object)this.getServletName(), (Object)contextPath);
    }

    public void destroy() {
        DefaultHttpRegistry.removeHttpRegistry(this.getServletName());
        if (this.httpRegistry != null) {
            this.httpRegistry.unregister(this);
            this.httpRegistry = null;
        }
        LOG.info("Destroyed CamelHttpTransportServlet[{}]", (Object)this.getServletName());
    }

    private ServletEndpoint getServletEndpoint(HttpConsumer consumer) {
        if (!(consumer.getEndpoint() instanceof ServletEndpoint)) {
            throw new RuntimeException("Invalid consumer type. Must be ServletEndpoint but is " + ((Object)((Object)consumer)).getClass().getName());
        }
        return (ServletEndpoint)consumer.getEndpoint();
    }

    @Override
    public void connect(HttpConsumer consumer) {
        ServletEndpoint endpoint = this.getServletEndpoint(consumer);
        if (endpoint.getServletName() != null && endpoint.getServletName().equals(this.getServletName())) {
            super.connect(consumer);
        }
    }

    public boolean isIgnoreDuplicateServletName() {
        return this.ignoreDuplicateServletName;
    }

    public String toString() {
        String name = this.getServletName();
        if (name != null) {
            return "CamelHttpTransportServlet[name=" + this.getServletName() + "]";
        }
        return "CamelHttpTransportServlet";
    }
}

