/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.http.common.CamelServlet;
import org.apache.camel.http.common.DefaultHttpRegistry;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpRegistry;
import org.apache.camel.http.common.HttpRegistryProvider;
import org.apache.camel.http.common.HttpRestServletResolveConsumerStrategy;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelHttpTransportServlet
extends CamelServlet {
    private static final long serialVersionUID = -1797014782158930490L;
    private static final Logger LOG = LoggerFactory.getLogger(CamelHttpTransportServlet.class);
    private HttpRegistry httpRegistry;
    private boolean ignoreDuplicateServletName;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.setServletResolveConsumerStrategy(new HttpRestServletResolveConsumerStrategy());
        String ignore = config.getInitParameter("ignoreDuplicateServletName");
        if (ObjectHelper.isNotEmpty(ignore)) {
            this.ignoreDuplicateServletName = Boolean.parseBoolean(ignore);
        }
        String name = config.getServletName();
        String contextPath = config.getServletContext().getContextPath();
        if (this.httpRegistry == null) {
            this.httpRegistry = DefaultHttpRegistry.getHttpRegistry(name);
            HttpRegistryProvider existing = this.httpRegistry.getCamelServlet(name);
            if (existing != null) {
                String msg = "Duplicate ServletName detected: " + name + ". Existing: " + existing + " This: " + this.toString() + ". Its advised to use unique ServletName per Camel application.";
                if (this.isIgnoreDuplicateServletName()) {
                    LOG.warn(msg);
                } else {
                    LOG.error(msg);
                    throw new ServletException(msg);
                }
            }
            this.httpRegistry.register(this);
        }
        LOG.info("Initialized CamelHttpTransportServlet[name={}, contextPath={}]", (Object)this.getServletName(), (Object)contextPath);
    }

    public void destroy() {
        DefaultHttpRegistry.removeHttpRegistry(this.getServletName());
        if (this.httpRegistry != null) {
            this.httpRegistry.unregister(this);
            this.httpRegistry = null;
        }
        LOG.info("Destroyed CamelHttpTransportServlet[{}]", (Object)this.getServletName());
    }

    private ServletEndpoint getServletEndpoint(HttpConsumer consumer) {
        if (!(consumer.getEndpoint() instanceof ServletEndpoint)) {
            throw new RuntimeException("Invalid consumer type. Must be ServletEndpoint but is " + consumer.getClass().getName());
        }
        return (ServletEndpoint)consumer.getEndpoint();
    }

    @Override
    public void connect(HttpConsumer consumer) {
        ServletEndpoint endpoint = this.getServletEndpoint(consumer);
        if (endpoint.getServletName() != null && endpoint.getServletName().equals(this.getServletName())) {
            super.connect(consumer);
        }
    }

    public boolean isIgnoreDuplicateServletName() {
        return this.ignoreDuplicateServletName;
    }

    public String toString() {
        String name = this.getServletName();
        if (name != null) {
            return "CamelHttpTransportServlet[name=" + this.getServletName() + "]";
        }
        return "CamelHttpTransportServlet";
    }
}

