/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.servlet.ServletConsumer;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.component.servlet.ServletRestHttpBinding;
import org.apache.camel.http.common.DefaultHttpRegistry;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpCommonComponent;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpRegistry;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.RestComponentHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="servlet")
public class ServletComponent
extends HttpCommonComponent
implements RestConsumerFactory,
RestApiConsumerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ServletComponent.class);
    @Metadata(label="consumer", defaultValue="CamelServlet", description="Default name of servlet to use. The default name is CamelServlet.")
    private String servletName = "CamelServlet";
    @Metadata(label="consumer,advanced", description="To use a custom org.apache.camel.component.servlet.HttpRegistry.")
    private HttpRegistry httpRegistry;
    @Metadata(label="consumer,advanced", description="Whether to automatic bind multipart/form-data as attachments on the Camel Exchange. The options attachmentMultipartBinding=true and disableStreamCache=false cannot work together. Remove disableStreamCache to use AttachmentMultipartBinding. This is turn off by default as this may require servlet specific configuration to enable this when using Servlet's.")
    private boolean attachmentMultipartBinding;
    @Metadata(label="consumer,advanced", description="Whitelist of accepted filename extensions for accepting uploaded files. Multiple extensions can be separated by comma, such as txt,xml.")
    private String fileNameExtWhitelist;

    public ServletComponent() {
    }

    public ServletComponent(Class<? extends ServletEndpoint> endpointClass) {
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Boolean throwExceptionOnFailure = this.getAndRemoveParameter(parameters, "throwExceptionOnFailure", Boolean.class);
        Boolean transferException = this.getAndRemoveParameter(parameters, "transferException", Boolean.class);
        boolean muteException = this.getAndRemoveParameter(parameters, "muteException", Boolean.TYPE, this.isMuteException());
        Boolean bridgeEndpoint = this.getAndRemoveParameter(parameters, "bridgeEndpoint", Boolean.class);
        HttpBinding binding = this.resolveAndRemoveReferenceParameter(parameters, "httpBinding", HttpBinding.class);
        Boolean matchOnUriPrefix = this.getAndRemoveParameter(parameters, "matchOnUriPrefix", Boolean.class);
        String filteredServletName = this.getAndRemoveParameter(parameters, "servletName", String.class, this.getServletName());
        String httpMethodRestrict = this.getAndRemoveParameter(parameters, "httpMethodRestrict", String.class);
        HeaderFilterStrategy headerFilterStrategy = this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        Boolean async = this.getAndRemoveParameter(parameters, "async", Boolean.class);
        Boolean filteredAttachmentMultipartBinding = this.getAndRemoveParameter(parameters, "attachmentMultipartBinding", Boolean.class);
        Boolean disableStreamCache = this.getAndRemoveParameter(parameters, "disableStreamCache", Boolean.class);
        if (this.lenientContextPath()) {
            String scheme = StringHelper.before((String)uri, ":");
            Object after = StringHelper.after((String)uri, ":");
            while (((String)after).startsWith("/")) {
                after = ((String)after).substring(1);
            }
            after = "/" + (String)after;
            uri = scheme + ":" + (String)after;
        }
        URI httpUri = URISupport.createRemainingURI(new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)uri)), parameters);
        ServletEndpoint endpoint = this.createServletEndpoint((String)uri, this, httpUri);
        endpoint.setServletName(filteredServletName);
        endpoint.setFileNameExtWhitelist(this.fileNameExtWhitelist);
        if (async != null) {
            endpoint.setAsync(async);
        }
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy(endpoint);
        }
        if (binding == null) {
            binding = this.getHttpBinding();
        }
        if (binding != null) {
            endpoint.setHttpBinding(binding);
        }
        if (throwExceptionOnFailure != null) {
            endpoint.setThrowExceptionOnFailure(throwExceptionOnFailure);
        }
        if (transferException != null) {
            endpoint.setTransferException(transferException);
        }
        endpoint.setMuteException(muteException);
        if (bridgeEndpoint != null) {
            endpoint.setBridgeEndpoint(bridgeEndpoint);
        }
        if (matchOnUriPrefix != null) {
            endpoint.setMatchOnUriPrefix(matchOnUriPrefix);
        }
        if (httpMethodRestrict != null) {
            endpoint.setHttpMethodRestrict(httpMethodRestrict);
        }
        if (filteredAttachmentMultipartBinding != null) {
            endpoint.setAttachmentMultipartBinding(filteredAttachmentMultipartBinding);
        } else {
            endpoint.setAttachmentMultipartBinding(this.isAttachmentMultipartBinding());
        }
        if (disableStreamCache != null) {
            endpoint.setDisableStreamCache(disableStreamCache);
        }
        if (endpoint.isAttachmentMultipartBinding()) {
            if (disableStreamCache == null) {
                LOG.info("Disabling stream caching as attachmentMultipartBinding is enabled");
                endpoint.setDisableStreamCache(true);
            } else if (!disableStreamCache.booleanValue()) {
                throw new IllegalArgumentException("The options attachmentMultipartBinding=true and disableStreamCache=false cannot work together. Remove disableStreamCache to use AttachmentMultipartBinding");
            }
        }
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    protected boolean lenientContextPath() {
        return true;
    }

    protected ServletEndpoint createServletEndpoint(String endpointUri, ServletComponent component, URI httpUri) throws Exception {
        return new ServletEndpoint(endpointUri, component, httpUri);
    }

    @Override
    public void connect(HttpConsumer consumer) throws Exception {
        ServletConsumer sc = (ServletConsumer)consumer;
        String name = sc.getEndpoint().getServletName();
        HttpRegistry registry = this.httpRegistry;
        if (registry == null) {
            registry = DefaultHttpRegistry.getHttpRegistry(name);
        }
        registry.register(consumer);
    }

    @Override
    public void disconnect(HttpConsumer consumer) throws Exception {
        ServletConsumer sc = (ServletConsumer)consumer;
        String name = sc.getEndpoint().getServletName();
        HttpRegistry registry = this.httpRegistry;
        if (registry == null) {
            registry = DefaultHttpRegistry.getHttpRegistry(name);
        }
        registry.unregister(consumer);
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public HttpRegistry getHttpRegistry() {
        return this.httpRegistry;
    }

    public void setHttpRegistry(HttpRegistry httpRegistry) {
        this.httpRegistry = httpRegistry;
    }

    public boolean isAttachmentMultipartBinding() {
        return this.attachmentMultipartBinding;
    }

    public void setAttachmentMultipartBinding(boolean attachmentMultipartBinding) {
        this.attachmentMultipartBinding = attachmentMultipartBinding;
    }

    public String getFileNameExtWhitelist() {
        return this.fileNameExtWhitelist;
    }

    public void setFileNameExtWhitelist(String fileNameExtWhitelist) {
        this.fileNameExtWhitelist = fileNameExtWhitelist;
    }

    @Override
    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, configuration, parameters, false);
    }

    @Override
    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, configuration, parameters, true);
    }

    Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        Object path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? (String)path + uriTemplate : (String)path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        RestConfiguration config = configuration;
        if (config == null) {
            config = CamelContextHelper.getRestConfiguration(this.getCamelContext(), "servlet");
        }
        Map<String, Object> map = RestComponentHelper.initRestEndpointProperties("servlet", config);
        boolean cors = config.isEnableCORS();
        if (cors) {
            map.put("optionsEnabled", "true");
        }
        if (api) {
            map.put("matchOnUriPrefix", "true");
        }
        RestComponentHelper.addHttpRestrictParam(map, verb, cors);
        String url = RestComponentHelper.createRestConsumerUrl("servlet", (String)path, map);
        ServletEndpoint endpoint = (ServletEndpoint)camelContext.getEndpoint(url, parameters);
        if (!map.containsKey("httpBinding")) {
            ServletRestHttpBinding binding = new ServletRestHttpBinding();
            binding.setHeaderFilterStrategy(endpoint.getHeaderFilterStrategy());
            binding.setTransferException(endpoint.isTransferException());
            binding.setMuteException(endpoint.isMuteException());
            binding.setEagerCheckContentAvailable(endpoint.isEagerCheckContentAvailable());
            binding.setMapHttpMessageHeaders(endpoint.isMapHttpMessageHeaders());
            binding.setMapHttpMessageFormUrlEncodedBody(endpoint.isMapHttpMessageFormUrlEncodedBody());
            endpoint.setHttpBinding(binding);
        }
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        return consumer;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        try {
            RestConfiguration config = CamelContextHelper.getRestConfiguration(this.getCamelContext(), "servlet");
            if (config.getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
                this.setProperties(this, config.getComponentProperties());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

