/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sip;

import java.util.Properties;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.ListeningPoint;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.message.Request;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.sip.SipConfiguration;
import org.apache.camel.component.sip.SipEndpoint;
import org.apache.camel.component.sip.listener.SipSubscriptionListener;
import org.apache.camel.impl.DefaultConsumer;

public class SipSubscriber
extends DefaultConsumer {
    private SipConfiguration configuration;
    private SipSubscriptionListener sipSubscriptionListener;
    private SipProvider provider;
    private Dialog subscriberDialog;
    private SipStack sipStack;

    public SipSubscriber(SipEndpoint sipEndpoint, Processor processor, SipConfiguration configuration) {
        super((Endpoint)sipEndpoint, processor);
        this.configuration = configuration;
        this.configuration.setConsumer(true);
    }

    protected void doStart() throws Exception {
        super.doStart();
        Properties properties = this.configuration.createInitialProperties();
        this.sipStack = this.configuration.getSipFactory().createSipStack(properties);
        this.configuration.parseURI();
        this.sipSubscriptionListener = new SipSubscriptionListener(this);
        ListeningPoint listeningPoint = this.sipStack.createListeningPoint(this.configuration.getFromHost(), this.configuration.getFromPort(), this.configuration.getTransport());
        this.configuration.setListeningPoint(listeningPoint);
        this.provider = this.sipStack.createSipProvider(this.configuration.getListeningPoint());
        this.provider.addSipListener(this.sipSubscriptionListener);
        if (this.configuration.getCallIdHeader() == null) {
            this.configuration.setCallIdHeader(this.provider.getNewCallId());
        }
        this.configuration.setCallIdHeader(this.provider.getNewCallId());
        Request request = this.configuration.createSipRequest(1L, "SUBSCRIBE", this.configuration.getEventHeaderName());
        ClientTransaction subscriberTransactionId = this.provider.getNewClientTransaction(request);
        request.addHeader(this.configuration.getEventHeader());
        this.subscriberDialog = subscriberTransactionId.getDialog();
        subscriberTransactionId.sendRequest();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public SipConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SipConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setSipSubscriptionListener(SipSubscriptionListener sipSubscriptionListener) {
        this.sipSubscriptionListener = sipSubscriptionListener;
    }

    public SipSubscriptionListener getSipSubscriptionListener() {
        return this.sipSubscriptionListener;
    }

    public void setSipStack(SipStack sipStack) {
        this.sipStack = sipStack;
    }

    public SipStack getSipStack() {
        return this.sipStack;
    }

    public SipProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SipProvider provider) {
        this.provider = provider;
    }

    public Dialog getSubscriberDialog() {
        return this.subscriberDialog;
    }
}

