/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sip;

import java.util.Properties;
import javax.sip.ListeningPoint;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.message.Request;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.component.sip.SipConfiguration;
import org.apache.camel.component.sip.SipEndpoint;
import org.apache.camel.component.sip.listener.SipPublishListener;
import org.apache.camel.impl.DefaultProducer;

public class SipPublisher
extends DefaultProducer
implements ServicePoolAware {
    private SipConfiguration configuration;
    private long sequenceNumber = 1L;
    private SipPublishListener sipPublishListener;
    private SipProvider provider;
    private SipStack sipStack;

    public SipPublisher(SipEndpoint sipEndpoint, SipConfiguration configuration) {
        super((Endpoint)sipEndpoint);
        this.setConfiguration(configuration);
    }

    protected void doStart() throws Exception {
        super.doStart();
        Properties properties = this.configuration.createInitialProperties();
        this.setSipStack(this.configuration.getSipFactory().createSipStack(properties));
        this.configuration.parseURI();
        if (this.sipPublishListener == null) {
            this.sipPublishListener = new SipPublishListener(this);
        }
        this.configuration.setListeningPoint(this.sipStack.createListeningPoint(this.configuration.getFromHost(), this.configuration.getFromPort(), this.configuration.getTransport()));
        boolean found = false;
        if (this.provider != null) {
            for (ListeningPoint listeningPoint : this.provider.getListeningPoints()) {
                if (!listeningPoint.getIPAddress().equalsIgnoreCase(this.configuration.getListeningPoint().getIPAddress()) || listeningPoint.getPort() != this.configuration.getListeningPoint().getPort()) continue;
                found = true;
            }
        }
        if (!found) {
            this.provider = this.getSipStack().createSipProvider(this.configuration.getListeningPoint());
            this.provider.addSipListener(this.sipPublishListener);
            this.configuration.setCallIdHeader(this.provider.getNewCallId());
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.getSipStack().deleteListeningPoint(this.configuration.getListeningPoint());
        this.provider.removeSipListener(this.sipPublishListener);
        this.getSipStack().deleteSipProvider(this.provider);
        this.getSipStack().stop();
    }

    public void process(Exchange exchange) throws Exception {
        String requestMethod = (String)exchange.getIn().getHeader("REQUEST_METHOD", String.class);
        if (requestMethod == null) {
            throw new CamelExchangeException("Missing mandatory Header: REQUEST_HEADER", exchange);
        }
        Object body = exchange.getIn().getBody();
        Request request = this.configuration.createSipRequest(this.sequenceNumber, requestMethod, body);
        this.provider.sendRequest(request);
    }

    public void setConfiguration(SipConfiguration configuration) {
        this.configuration = configuration;
    }

    public SipConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setSipStack(SipStack sipStack) {
        this.sipStack = sipStack;
    }

    public SipStack getSipStack() {
        return this.sipStack;
    }
}

