/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sip.listener;

import java.text.ParseException;
import java.util.UUID;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.SipURI;
import javax.sip.header.EventHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.camel.component.sip.SipPresenceAgent;
import org.apache.camel.component.sip.listener.SipMessageCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipPresenceAgentListener
implements SipListener,
SipMessageCodes {
    private static final Logger LOG = LoggerFactory.getLogger(SipPresenceAgentListener.class);
    protected Dialog dialog;
    protected int notifyCount;
    private SipPresenceAgent sipPresenceAgent;

    public SipPresenceAgentListener(SipPresenceAgent sipPresenceAgent) {
        this.sipPresenceAgent = sipPresenceAgent;
    }

    @Override
    public void processRequest(RequestEvent requestEvent) {
        Request request = requestEvent.getRequest();
        ServerTransaction serverTransactionId = requestEvent.getServerTransaction();
        LOG.debug("Request: {}", (Object)request.getMethod());
        LOG.debug("Server Transaction Id: {}", (Object)serverTransactionId);
        if (request.getMethod().equals("SUBSCRIBE")) {
            this.processSubscribe(requestEvent, serverTransactionId);
        } else if (request.getMethod().equals("PUBLISH")) {
            this.processPublish(requestEvent, serverTransactionId);
        } else {
            LOG.debug("Received expected request with method: {}. No further processing done", (Object)request.getMethod());
        }
    }

    private void sendNotification(EventHeader eventHeader, boolean isInitial, Object body) throws SipException, ParseException {
        SubscriptionStateHeader sstate;
        Request notifyRequest = this.dialog.createRequest("NOTIFY");
        ((SipURI)this.sipPresenceAgent.getConfiguration().getContactHeader().getAddress().getURI()).setParameter(this.sipPresenceAgent.getConfiguration().getFromUser(), this.sipPresenceAgent.getConfiguration().getFromHost());
        if (isInitial) {
            sstate = this.sipPresenceAgent.getConfiguration().getHeaderFactory().createSubscriptionStateHeader(isInitial ? "pending" : "terminated");
            if (sstate.getState().equalsIgnoreCase("terminated")) {
                sstate.setReasonCode("deactivated");
            }
        } else {
            sstate = this.sipPresenceAgent.getConfiguration().getHeaderFactory().createSubscriptionStateHeader("active");
        }
        notifyRequest.addHeader(sstate);
        notifyRequest.setHeader(eventHeader);
        notifyRequest.setHeader(this.sipPresenceAgent.getConfiguration().getContactHeader());
        notifyRequest.setContent(body, this.sipPresenceAgent.getConfiguration().getContentTypeHeader());
        LOG.debug("Sending the following NOTIFY request to Subscriber: {}", (Object)notifyRequest);
        ClientTransaction clientTransactionId = this.sipPresenceAgent.getProvider().getNewClientTransaction(notifyRequest);
        this.dialog.sendRequest(clientTransactionId);
    }

    private void processPublish(RequestEvent requestEvent, ServerTransaction serverTransactionId) {
        try {
            Request request = requestEvent.getRequest();
            LOG.debug("SipPresenceAgentListener: Received a Publish request, sending OK");
            LOG.debug("SipPresenceAgentListener request: {}", (Object)request);
            EventHeader eventHeader = (EventHeader)requestEvent.getRequest().getHeader("Event");
            Response response = this.sipPresenceAgent.getConfiguration().getMessageFactory().createResponse(202, request);
            this.sipPresenceAgent.getProvider().sendResponse(response);
            this.sendNotification(eventHeader, false, request.getContent());
        }
        catch (Exception e) {
            LOG.error("Exception thrown during publish/notify processing in the Sip Presence Agent Listener", (Throwable)e);
        }
    }

    public void processSubscribe(RequestEvent requestEvent, ServerTransaction serverTransaction) {
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        Request request = requestEvent.getRequest();
        try {
            boolean isInitial;
            LOG.debug("SipPresenceAgentListener: Received a Subscribe request, sending OK");
            LOG.debug("SipPresenceAgentListener request: {}", (Object)request);
            EventHeader eventHeader = (EventHeader)request.getHeader("Event");
            if (eventHeader == null) {
                LOG.debug("Cannot find event header.... dropping request.");
                return;
            }
            Response response = null;
            ServerTransaction st = requestEvent.getServerTransaction();
            if (st == null) {
                st = sipProvider.getNewServerTransaction(request);
            }
            boolean bl = isInitial = requestEvent.getDialog() == null;
            if (isInitial) {
                String toTag = UUID.randomUUID().toString();
                response = this.sipPresenceAgent.getConfiguration().getMessageFactory().createResponse(202, request);
                ToHeader toHeader = (ToHeader)response.getHeader("To");
                toHeader.setTag(toTag);
                this.dialog = st.getDialog();
                this.dialog.terminateOnBye(false);
            } else {
                response = this.sipPresenceAgent.getConfiguration().getMessageFactory().createResponse(200, request);
            }
            response.addHeader(this.sipPresenceAgent.getConfiguration().getContactHeader());
            response.addHeader(this.sipPresenceAgent.getConfiguration().getExpiresHeader());
            st.sendResponse(response);
            LOG.debug("SipPresenceAgentListener: Sent OK Message");
            LOG.debug("SipPresenceAgentListener response: {}", (Object)response);
            this.sendNotification(eventHeader, isInitial, request.getContent());
        }
        catch (Throwable e) {
            LOG.error("Exception thrown during Notify processing in the SipPresenceAgentListener.", e);
        }
    }

    @Override
    public synchronized void processResponse(ResponseEvent responseReceivedEvent) {
        Response response = responseReceivedEvent.getResponse();
        Integer statusCode = response.getStatusCode();
        if (SIP_MESSAGE_CODES.containsKey(statusCode)) {
            LOG.debug((String)SIP_MESSAGE_CODES.get(statusCode) + " received from Subscriber");
        }
    }

    @Override
    public void processTimeout(TimeoutEvent timeoutEvent) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("TimeoutEvent received at Sip Presence Agent Listener");
        }
    }

    @Override
    public void processIOException(IOExceptionEvent exceptionEvent) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("IOExceptionEvent received at SipPresenceAgentListener");
        }
    }

    @Override
    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("TransactionTerminatedEvent received at SipPresenceAgentListener");
        }
    }

    @Override
    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("DialogTerminatedEvent received at SipPresenceAgentListener");
        }
    }
}

