/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sip;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.sip.SipConfiguration;
import org.apache.camel.component.sip.SipPresenceAgent;
import org.apache.camel.component.sip.SipPublisher;
import org.apache.camel.component.sip.SipSubscriber;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.5.0", scheme="sip,sips", title="SIP", syntax="sip:uri", category={Category.MOBILE})
public class SipEndpoint
extends DefaultEndpoint {
    @UriParam
    private SipConfiguration configuration;

    public SipEndpoint(String endpointUri, Component component, SipConfiguration configuration) {
        super(endpointUri, component);
        this.configuration = configuration;
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.configuration.isPresenceAgent()) {
            SipPresenceAgent answer = new SipPresenceAgent(this, processor, this.configuration);
            this.configureConsumer(answer);
            return answer;
        }
        SipSubscriber answer = new SipSubscriber(this, processor, this.configuration);
        this.configureConsumer(answer);
        return answer;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new SipPublisher(this, this.configuration);
    }

    public SipConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SipConfiguration configuration) {
        this.configuration = configuration;
    }
}

