/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sip;

import java.util.Properties;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import org.apache.camel.Processor;
import org.apache.camel.component.sip.SipConfiguration;
import org.apache.camel.component.sip.SipEndpoint;
import org.apache.camel.component.sip.listener.SipPresenceAgentListener;
import org.apache.camel.support.DefaultConsumer;

public class SipPresenceAgent
extends DefaultConsumer {
    private SipConfiguration configuration;
    private SipPresenceAgentListener sipPresenceAgentListener;
    private SipProvider provider;
    private SipStack sipStack;

    public SipPresenceAgent(SipEndpoint sipEndpoint, Processor processor, SipConfiguration configuration) {
        super(sipEndpoint, processor);
        this.configuration = configuration;
        this.configuration.setConsumer(true);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        Properties properties = this.configuration.createInitialProperties();
        this.setSipStack(this.configuration.getSipFactory().createSipStack(properties));
        this.configuration.parseURI();
        this.sipPresenceAgentListener = new SipPresenceAgentListener(this);
        this.configuration.setListeningPoint(this.sipStack.createListeningPoint(this.configuration.getFromHost(), this.configuration.getFromPort(), this.configuration.getTransport()));
        this.provider = this.getSipStack().createSipProvider(this.configuration.getListeningPoint());
        this.provider.addSipListener(this.sipPresenceAgentListener);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.getSipStack().deleteListeningPoint(this.configuration.getListeningPoint());
        this.provider.removeSipListener(this.sipPresenceAgentListener);
        this.getSipStack().deleteSipProvider(this.provider);
        this.getSipStack().stop();
    }

    public SipConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SipConfiguration configuration) {
        this.configuration = configuration;
    }

    public SipProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SipProvider provider) {
        this.provider = provider;
    }

    public void setSipStack(SipStack sipStack) {
        this.sipStack = sipStack;
    }

    public SipStack getSipStack() {
        return this.sipStack;
    }
}

