/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.producer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.sjms.BatchMessage;
import org.apache.camel.component.sjms.MessageProducerResources;
import org.apache.camel.component.sjms.SjmsProducer;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.jms.JmsMessageHelper;
import org.apache.camel.component.sjms.jms.JmsObjectFactory;
import org.apache.camel.component.sjms.tx.DefaultTransactionCommitStrategy;
import org.apache.camel.component.sjms.tx.SessionTransactionSynchronization;
import org.apache.camel.spi.Synchronization;

public class InOnlyProducer
extends SjmsProducer {
    public InOnlyProducer(Endpoint endpoint) {
        super(endpoint);
    }

    @Override
    public MessageProducerResources doCreateProducerModel() throws Exception {
        MessageProducerResources answer;
        Connection conn = this.getConnectionResource().borrowConnection();
        try {
            TransactionCommitStrategy commitStrategy = null;
            if (this.isEndpointTransacted()) {
                commitStrategy = this.getCommitStrategy() == null ? new DefaultTransactionCommitStrategy() : this.getCommitStrategy();
            }
            Session session = conn.createSession(this.isEndpointTransacted(), this.getAcknowledgeMode());
            Destination destination = this.getEndpoint().getDestinationCreationStrategy().createDestination(session, this.getDestinationName(), this.isTopic());
            MessageProducer messageProducer = JmsObjectFactory.createMessageProducer(session, destination, this.isPersistent(), this.getTtl());
            answer = new MessageProducerResources(session, messageProducer, commitStrategy);
        }
        catch (Exception e) {
            this.log.error("Unable to create the MessageProducer", (Throwable)e);
            throw e;
        }
        finally {
            this.getConnectionResource().returnConnection(conn);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Exchange exchange, AsyncCallback callback, MessageProducerResources producer) throws Exception {
        try {
            ArrayList<Message> messages = new ArrayList<Message>(1);
            if (exchange.getIn().getBody() != null) {
                Object payload;
                if (exchange.getIn().getBody() instanceof List) {
                    payload = (Iterable)exchange.getIn().getBody();
                    Iterator i$ = payload.iterator();
                    while (i$.hasNext()) {
                        Message message;
                        Object object = i$.next();
                        if (BatchMessage.class.isInstance(object)) {
                            BatchMessage batchMessage = (BatchMessage)object;
                            message = JmsMessageHelper.createMessage(producer.getSession(), batchMessage.getPayload(), batchMessage.getHeaders(), this.getEndpoint());
                        } else {
                            message = JmsMessageHelper.createMessage(producer.getSession(), object, exchange.getIn().getHeaders(), this.getEndpoint());
                        }
                        messages.add(message);
                    }
                } else {
                    payload = exchange.getIn().getBody();
                    Message message = JmsMessageHelper.createMessage(producer.getSession(), payload, exchange.getIn().getHeaders(), this.getEndpoint());
                    messages.add(message);
                }
            }
            if (this.isEndpointTransacted()) {
                exchange.getUnitOfWork().addSynchronization((Synchronization)new SessionTransactionSynchronization(producer.getSession(), producer.getCommitStrategy()));
            }
            for (Message message : messages) {
                producer.getMessageProducer().send(message);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)new Exception("Unable to complete sending the message: ", e));
        }
        finally {
            if (producer != null) {
                this.getProducers().returnObject((Object)producer);
            }
            callback.done(this.isSynchronous());
        }
    }
}

