/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.rate_limits.metrics.impl;

import com.google.gson.Gson;
import com.slack.api.rate_limits.metrics.LastMinuteRequests;
import com.slack.api.rate_limits.metrics.LiveRequestStats;
import com.slack.api.rate_limits.metrics.MetricsDatastore;
import com.slack.api.rate_limits.metrics.RequestStats;
import com.slack.api.rate_limits.queue.QueueMessage;
import com.slack.api.rate_limits.queue.RateLimitQueue;
import com.slack.api.rate_limits.queue.WaitingMessageIds;
import com.slack.api.util.json.GsonFactory;
import com.slack.api.util.thread.ExecutorServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public abstract class BaseMemoryMetricsDatastore<SUPPLIER, MSG extends QueueMessage>
implements MetricsDatastore,
AutoCloseable {
    private final ScheduledExecutorService cleanerExecutor;
    private final int numberOfNodes;
    private static final Gson GSON = GsonFactory.createSnakeCase();
    private static final ConcurrentMap<String, ConcurrentMap<String, LiveRequestStats>> ALL_LIVE_STATS = new ConcurrentHashMap<String, ConcurrentMap<String, LiveRequestStats>>();
    private static final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, WaitingMessageIds>>> ALL_MESSAGE_IDS = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<String, WaitingMessageIds>>>();
    private static final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, LastMinuteRequests>>> ALL_LAST_MINUTE_REQUESTS = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<String, LastMinuteRequests>>>();

    public BaseMemoryMetricsDatastore(int numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
        this.cleanerExecutor = ExecutorServiceFactory.createDaemonThreadScheduledExecutor(this.getThreadGroupName());
        this.cleanerExecutor.scheduleAtFixedRate(new MaintenanceJob(this), 1000L, 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws Exception {
        this.cleanerExecutor.shutdown();
    }

    protected abstract String getMetricsType();

    public String getThreadGroupName() {
        return "slack-api-client-metrics-memory:" + Integer.toHexString(this.hashCode());
    }

    @Override
    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    @Override
    public Map<String, Map<String, RequestStats>> getAllStats() {
        HashMap<String, Map<String, RequestStats>> result = new HashMap<String, Map<String, RequestStats>>();
        for (Map.Entry executor : ALL_LIVE_STATS.entrySet()) {
            HashMap<String, RequestStats> allTeams = new HashMap<String, RequestStats>();
            for (Map.Entry team : ((ConcurrentMap)executor.getValue()).entrySet()) {
                RequestStats stats = GSON.fromJson(GSON.toJson(team.getValue()), RequestStats.class);
                allTeams.put((String)team.getKey(), stats);
            }
            result.put((String)executor.getKey(), allTeams);
        }
        return result;
    }

    @Override
    public RequestStats getStats(String executorName, String teamId) {
        LiveRequestStats internal = this.getOrCreateTeamLiveStats(executorName, teamId);
        RequestStats stats = GSON.fromJson(GSON.toJson(internal), RequestStats.class);
        return stats;
    }

    @Override
    public void incrementAllCompletedCalls(String executorName, String teamId, String methodName) {
        LiveRequestStats stats = this.getOrCreateTeamLiveStats(executorName, teamId);
        if (stats.getAllCompletedCalls().get(methodName) == null) {
            stats.getAllCompletedCalls().putIfAbsent(methodName, new AtomicLong(0L));
        }
        ((AtomicLong)stats.getAllCompletedCalls().get(methodName)).incrementAndGet();
    }

    @Override
    public void incrementSuccessfulCalls(String executorName, String teamId, String methodName) {
        LiveRequestStats stats = this.getOrCreateTeamLiveStats(executorName, teamId);
        if (stats.getSuccessfulCalls().get(methodName) == null) {
            stats.getSuccessfulCalls().putIfAbsent(methodName, new AtomicLong(0L));
        }
        ((AtomicLong)stats.getSuccessfulCalls().get(methodName)).incrementAndGet();
    }

    @Override
    public void incrementUnsuccessfulCalls(String executorName, String teamId, String methodName) {
        LiveRequestStats stats = this.getOrCreateTeamLiveStats(executorName, teamId);
        if (stats.getUnsuccessfulCalls().get(methodName) == null) {
            stats.getUnsuccessfulCalls().putIfAbsent(methodName, new AtomicLong(0L));
        }
        ((AtomicLong)stats.getUnsuccessfulCalls().get(methodName)).incrementAndGet();
    }

    @Override
    public void incrementFailedCalls(String executorName, String teamId, String methodName) {
        LiveRequestStats stats = this.getOrCreateTeamLiveStats(executorName, teamId);
        if (stats.getFailedCalls().get(methodName) == null) {
            stats.getFailedCalls().putIfAbsent(methodName, new AtomicLong(0L));
        }
        ((AtomicLong)stats.getFailedCalls().get(methodName)).incrementAndGet();
    }

    public abstract RateLimitQueue<SUPPLIER, MSG> getRateLimitQueue(String var1, String var2);

    @Override
    public void updateCurrentQueueSize(String executorName, String teamId, String methodName) {
        WaitingMessageIds messageIds = this.getOrCreateMessageIds(executorName, teamId, methodName);
        Integer totalSize = messageIds.size();
        RateLimitQueue<SUPPLIER, MSG> queue = this.getRateLimitQueue(executorName, teamId);
        if (queue != null) {
            totalSize = totalSize + queue.getCurrentActiveQueueSize(methodName);
        }
        this.setCurrentQueueSize(executorName, teamId, methodName, totalSize);
    }

    @Override
    public void setCurrentQueueSize(String executorName, String teamId, String methodName, Integer size) {
        WaitingMessageIds messageIds = this.getOrCreateMessageIds(executorName, teamId, methodName);
        Integer totalSize = messageIds.size();
        RateLimitQueue<SUPPLIER, MSG> queue = this.getRateLimitQueue(executorName, teamId);
        if (queue != null) {
            totalSize = totalSize + queue.getCurrentActiveQueueSize(methodName);
        }
        this.getOrCreateTeamLiveStats(executorName, teamId).getCurrentQueueSize().put(methodName, totalSize);
        this.getOrCreateTeamLiveStats(executorName, teamId).getCurrentQueueSize().put(methodName, size);
    }

    @Override
    public Integer getNumberOfLastMinuteRequests(String executorName, String teamId, String methodName) {
        return this.getOrCreateLastMinuteRequests(executorName, teamId, methodName).size();
    }

    @Override
    public void updateNumberOfLastMinuteRequests(String executorName, String teamId, String methodName) {
        LastMinuteRequests requests = this.getOrCreateLastMinuteRequests(executorName, teamId, methodName);
        long oneMinuteAgo = System.currentTimeMillis() - 60000L;
        for (Long millis : requests) {
            if (millis >= oneMinuteAgo) continue;
            requests.remove(millis);
        }
        this.setNumberOfLastMinuteRequests(executorName, teamId, methodName, requests.size());
    }

    @Override
    public void setNumberOfLastMinuteRequests(String executorName, String teamId, String methodName, Integer value) {
        ConcurrentMap<String, Integer> lastMinuteRequests = this.getOrCreateTeamLiveStats(executorName, teamId).getLastMinuteRequests();
        lastMinuteRequests.put(methodName, value);
    }

    @Override
    public Long getRateLimitedMethodRetryEpochMillis(String executorName, String teamId, String methodName) {
        return (Long)this.getOrCreateTeamLiveStats(executorName, teamId).getRateLimitedMethods().get(methodName);
    }

    @Override
    public void setRateLimitedMethodRetryEpochMillis(String executorName, String teamId, String methodName, Long epochTimeMillis) {
        this.getOrCreateTeamLiveStats(executorName, teamId).getRateLimitedMethods().put(methodName, epochTimeMillis);
    }

    @Override
    public void addToLastMinuteRequests(String executorName, String teamId, String methodName, Long currentMillis) {
        this.getOrCreateLastMinuteRequests(executorName, teamId, methodName).add(currentMillis);
        this.updateNumberOfLastMinuteRequests(executorName, teamId, methodName);
    }

    @Override
    public LastMinuteRequests getLastMinuteRequests(String executorName, String teamId, String methodName) {
        return this.getOrCreateLastMinuteRequests(executorName, teamId, methodName);
    }

    @Override
    public void addToWaitingMessageIds(String executorName, String teamId, String methodName, String messageId) {
        if (teamId == null) {
            teamId = "none";
        }
        WaitingMessageIds messageIds = this.getOrCreateMessageIds(executorName, teamId, methodName);
        messageIds.add(messageId);
    }

    @Override
    public void deleteFromWaitingMessageIds(String executorName, String teamId, String methodName, String messageId) {
        if (teamId == null) {
            teamId = "none";
        }
        WaitingMessageIds messageIds = this.getOrCreateMessageIds(executorName, teamId, methodName);
        messageIds.remove(messageId);
    }

    private ConcurrentMap<String, LiveRequestStats> getOrCreateExecutorLiveStats(String executorName) {
        String key = this.getMetricsType() + "/" + executorName;
        if (ALL_LIVE_STATS.get(key) == null) {
            ALL_LIVE_STATS.putIfAbsent(key, new ConcurrentHashMap());
        }
        return (ConcurrentMap)ALL_LIVE_STATS.get(key);
    }

    private LiveRequestStats getOrCreateTeamLiveStats(String executorName, String teamId) {
        ConcurrentMap<String, LiveRequestStats> executor = this.getOrCreateExecutorLiveStats(executorName);
        if (teamId == null) {
            teamId = "-";
        }
        if (executor.get(teamId) == null) {
            executor.putIfAbsent(teamId, new LiveRequestStats());
        }
        return (LiveRequestStats)executor.get(teamId);
    }

    private WaitingMessageIds getOrCreateMessageIds(String executorName, String teamId, String methodName) {
        if (ALL_MESSAGE_IDS.get(executorName) == null) {
            ALL_MESSAGE_IDS.putIfAbsent(executorName, new ConcurrentHashMap());
        }
        if (((ConcurrentMap)ALL_MESSAGE_IDS.get(executorName)).get(teamId) == null) {
            ((ConcurrentMap)ALL_MESSAGE_IDS.get(executorName)).putIfAbsent(teamId, new ConcurrentHashMap());
        }
        if (((ConcurrentMap)((ConcurrentMap)ALL_MESSAGE_IDS.get(executorName)).get(teamId)).get(methodName) == null) {
            ((ConcurrentMap)((ConcurrentMap)ALL_MESSAGE_IDS.get(executorName)).get(teamId)).putIfAbsent(methodName, new WaitingMessageIds());
        }
        return (WaitingMessageIds)((ConcurrentMap)((ConcurrentMap)ALL_MESSAGE_IDS.get(executorName)).get(teamId)).get(methodName);
    }

    private LastMinuteRequests getOrCreateLastMinuteRequests(String executorName, String teamId, String methodName) {
        if (ALL_LAST_MINUTE_REQUESTS.get(executorName) == null) {
            ALL_LAST_MINUTE_REQUESTS.putIfAbsent(executorName, new ConcurrentHashMap());
        }
        if (((ConcurrentMap)ALL_LAST_MINUTE_REQUESTS.get(executorName)).get(teamId) == null) {
            ((ConcurrentMap)ALL_LAST_MINUTE_REQUESTS.get(executorName)).putIfAbsent(teamId, new ConcurrentHashMap());
        }
        if (((ConcurrentMap)((ConcurrentMap)ALL_LAST_MINUTE_REQUESTS.get(executorName)).get(teamId)).get(methodName) == null) {
            ((ConcurrentMap)((ConcurrentMap)ALL_LAST_MINUTE_REQUESTS.get(executorName)).get(teamId)).putIfAbsent(methodName, new LastMinuteRequests());
        }
        return (LastMinuteRequests)((ConcurrentMap)((ConcurrentMap)ALL_LAST_MINUTE_REQUESTS.get(executorName)).get(teamId)).get(methodName);
    }

    private static class MaintenanceJob
    implements Runnable {
        private final BaseMemoryMetricsDatastore store;

        MaintenanceJob(BaseMemoryMetricsDatastore store) {
            this.store = store;
        }

        @Override
        public void run() {
            for (Map.Entry executor : ALL_LIVE_STATS.entrySet()) {
                String type;
                String[] elements = ((String)executor.getKey()).split("/");
                if (elements.length < 2 || (type = elements[0]) == null || !type.equals(this.store.getMetricsType())) continue;
                String executorName = ((String)executor.getKey()).replaceFirst("^" + type + "/", "");
                for (Map.Entry team : ((ConcurrentMap)executor.getValue()).entrySet()) {
                    String teamId = (String)team.getKey();
                    LiveRequestStats stats = (LiveRequestStats)team.getValue();
                    for (String methodName : stats.getLastMinuteRequests().keySet()) {
                        this.store.updateNumberOfLastMinuteRequests(executorName, teamId, methodName);
                    }
                    for (String methodName : stats.getCurrentQueueSize().keySet()) {
                        this.store.updateCurrentQueueSize(executorName, teamId, methodName);
                    }
                    ArrayList<String> methodNamesToRemove = new ArrayList<String>();
                    for (Map.Entry each : stats.getRateLimitedMethods().entrySet()) {
                        String methodName = (String)each.getKey();
                        Long millisToRetry = (Long)each.getValue();
                        long nowMillis = System.currentTimeMillis();
                        if (millisToRetry >= nowMillis) continue;
                        methodNamesToRemove.add(methodName);
                    }
                    for (String methodName : methodNamesToRemove) {
                        stats.getRateLimitedMethods().remove(methodName);
                    }
                }
            }
        }
    }
}

