/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.http;

import java.util.Map;
import lombok.Generated;
import okhttp3.Credentials;

public class ProxyUrlUtil {
    private ProxyUrlUtil() {
    }

    public static ProxyUrl parse(String proxyUrl) {
        if (proxyUrl == null) {
            return null;
        }
        String[] proxyUrlElements = proxyUrl.split("://");
        String schema = proxyUrlElements[0] + "://";
        String urlWithoutSchema = proxyUrlElements[1];
        String[] urlWithUserAndPasswordIfTwoElements = urlWithoutSchema.split("@");
        if (urlWithUserAndPasswordIfTwoElements.length == 2) {
            String[] userAndPassword = urlWithUserAndPasswordIfTwoElements[0].split(":");
            if (userAndPassword.length != 2) {
                throw new IllegalArgumentException("Invalid proxy URL: " + proxyUrl);
            }
            String[] hostAndPort = urlWithUserAndPasswordIfTwoElements[1].split(":");
            return ProxyUrl.builder().schema(schema).username(userAndPassword[0]).password(userAndPassword[1]).host(hostAndPort[0]).port(hostAndPort.length == 2 ? Integer.valueOf(hostAndPort[1]) : null).build();
        }
        String[] hostAndPort = proxyUrl.split("://")[1].split(":");
        return ProxyUrl.builder().schema(schema).host(hostAndPort[0]).port(hostAndPort.length == 2 ? Integer.valueOf(hostAndPort[1]) : null).build();
    }

    public static void setProxyAuthorizationHeader(Map<String, String> proxyHeaders, ProxyUrl parsedProxy) {
        if (parsedProxy.getUsername() != null && parsedProxy.getPassword() != null) {
            String headerValue = Credentials.basic(parsedProxy.getUsername(), parsedProxy.getPassword());
            proxyHeaders.put("Proxy-Authorization", headerValue);
        }
    }

    public static class ProxyUrl {
        private String schema;
        private String username;
        private String password;
        private String host;
        private Integer port;

        public String toUrlWithoutUserAndPassword() {
            return this.schema + this.host + (this.port != null ? ":" + this.port : "");
        }

        @Generated
        public static ProxyUrlBuilder builder() {
            return new ProxyUrlBuilder();
        }

        @Generated
        public ProxyUrl(String schema, String username, String password, String host, Integer port) {
            this.schema = schema;
            this.username = username;
            this.password = password;
            this.host = host;
            this.port = port;
        }

        @Generated
        public ProxyUrl() {
        }

        @Generated
        public String getSchema() {
            return this.schema;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public Integer getPort() {
            return this.port;
        }

        @Generated
        public void setSchema(String schema) {
            this.schema = schema;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public void setHost(String host) {
            this.host = host;
        }

        @Generated
        public void setPort(Integer port) {
            this.port = port;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProxyUrl)) {
                return false;
            }
            ProxyUrl other = (ProxyUrl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$port = this.getPort();
            Integer other$port = other.getPort();
            if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
                return false;
            }
            String this$schema = this.getSchema();
            String other$schema = other.getSchema();
            if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProxyUrl;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
            String $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProxyUrlUtil.ProxyUrl(schema=" + this.getSchema() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", host=" + this.getHost() + ", port=" + this.getPort() + ")";
        }

        @Generated
        public static class ProxyUrlBuilder {
            @Generated
            private String schema;
            @Generated
            private String username;
            @Generated
            private String password;
            @Generated
            private String host;
            @Generated
            private Integer port;

            @Generated
            ProxyUrlBuilder() {
            }

            @Generated
            public ProxyUrlBuilder schema(String schema) {
                this.schema = schema;
                return this;
            }

            @Generated
            public ProxyUrlBuilder username(String username) {
                this.username = username;
                return this;
            }

            @Generated
            public ProxyUrlBuilder password(String password) {
                this.password = password;
                return this;
            }

            @Generated
            public ProxyUrlBuilder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public ProxyUrlBuilder port(Integer port) {
                this.port = port;
                return this;
            }

            @Generated
            public ProxyUrl build() {
                return new ProxyUrl(this.schema, this.username, this.password, this.host, this.port);
            }

            @Generated
            public String toString() {
                return "ProxyUrlUtil.ProxyUrl.ProxyUrlBuilder(schema=" + this.schema + ", username=" + this.username + ", password=" + this.password + ", host=" + this.host + ", port=" + this.port + ")";
            }
        }
    }
}

