/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.extension.verifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.OptionsGroup;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.util.ObjectHelper;

public final class ResultErrorHelper {
    private ResultErrorHelper() {
    }

    public static Optional<ComponentVerifierExtension.VerificationError> requiresOption(String parameterName, Map<String, Object> parameters) {
        if (ObjectHelper.isEmpty(parameters.get(parameterName))) {
            return Optional.of(ResultErrorBuilder.withMissingOption(parameterName).build());
        }
        return Optional.empty();
    }

    public static List<ComponentVerifierExtension.VerificationError> requiresAny(Map<String, Object> parameters, OptionsGroup ... groups2) {
        return ResultErrorHelper.requiresAny(parameters, Arrays.asList(groups2));
    }

    public static List<ComponentVerifierExtension.VerificationError> requiresAny(Map<String, Object> parameters, Collection<OptionsGroup> groups2) {
        ArrayList<ComponentVerifierExtension.VerificationError> verificationErrors = new ArrayList<ComponentVerifierExtension.VerificationError>();
        HashSet<String> keys2 = new HashSet<String>(parameters.keySet());
        for (OptionsGroup group : groups2) {
            Set<String> required = ResultErrorHelper.required(group.getOptions());
            Set<String> excluded = ResultErrorHelper.excluded(group.getOptions());
            ResultErrorBuilder builder = new ResultErrorBuilder().code(ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_GROUP_COMBINATION).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.GroupAttribute.GROUP_NAME, (Object)group.getName()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.GroupAttribute.GROUP_OPTIONS, (Object)String.join((CharSequence)",", ResultErrorHelper.parameters(group.getOptions())));
            if (keys2.containsAll(required)) {
                HashSet<String> shouldBeExcluded = new HashSet<String>(keys2);
                shouldBeExcluded.retainAll(excluded);
                if (shouldBeExcluded.isEmpty()) {
                    return Collections.emptyList();
                }
                shouldBeExcluded.forEach(builder::parameterKey);
                verificationErrors.add(builder.build());
                continue;
            }
            for (String option : required) {
                if (parameters.containsKey(option)) continue;
                builder.parameterKey(option);
            }
            for (String option : excluded) {
                if (!parameters.containsKey(option)) continue;
                builder.parameterKey(option);
            }
            verificationErrors.add(builder.build());
        }
        return verificationErrors;
    }

    static Set<String> required(Set<String> options) {
        return options.stream().filter(o -> !o.startsWith("!")).collect(Collectors.toSet());
    }

    static Set<String> excluded(Set<String> options) {
        return options.stream().filter(o -> o.startsWith("!")).map(o -> o.substring(1)).collect(Collectors.toSet());
    }

    static Set<String> parameters(Set<String> options) {
        Set withoutExclusionMark = options.stream().map(o -> o.replaceFirst("!", "")).collect(Collectors.toSet());
        return new TreeSet<String>(withoutExclusionMark);
    }
}

