/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.List;
import java.util.function.BiFunction;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.StatefulService;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EventHelper.class);

    private EventHelper() {
    }

    public static boolean eventsApplicable(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean exchange = false;
        for (EventNotifier en : notifiers) {
            exchange |= !en.isIgnoreExchangeEvents();
        }
        return exchange;
    }

    public static boolean notifyCamelContextInitializing(CamelContext context) {
        return EventHelper.notifyCamelContext(context, EventFactory::createCamelContextInitializingEvent);
    }

    public static boolean notifyCamelContextInitialized(CamelContext context) {
        return EventHelper.notifyCamelContext(context, EventFactory::createCamelContextInitializedEvent);
    }

    public static boolean notifyCamelContextStarting(CamelContext context) {
        return EventHelper.notifyCamelContext(context, EventFactory::createCamelContextStartingEvent);
    }

    public static boolean notifyCamelContextStarted(CamelContext context) {
        return EventHelper.notifyCamelContext(context, EventFactory::createCamelContextStartedEvent);
    }

    public static boolean notifyCamelContextStartupFailed(CamelContext context, Throwable cause) {
        return EventHelper.notifyCamelContext(context, (ef, ctx) -> ef.createCamelContextStartupFailureEvent((CamelContext)ctx, cause));
    }

    public static boolean notifyCamelContextStopping(CamelContext context) {
        return EventHelper.notifyCamelContext(context, EventFactory::createCamelContextStoppingEvent);
    }

    public static boolean notifyCamelContextStopped(CamelContext context) {
        return EventHelper.notifyCamelContext(context, EventFactory::createCamelContextStoppedEvent);
    }

    public static boolean notifyCamelContextStopFailed(CamelContext context, Throwable cause) {
        return EventHelper.notifyCamelContext(context, (ef, ctx) -> ef.createCamelContextStopFailureEvent((CamelContext)ctx, cause));
    }

    private static boolean notifyCamelContext(CamelContext context, BiFunction<EventFactory, CamelContext, CamelEvent> eventSupplier) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = eventSupplier.apply(factory2, context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyServiceStopFailure(CamelContext context, Object service, Throwable cause) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreServiceEvents()) continue;
            if (event == null && (event = factory2.createServiceStopFailureEvent(context, service, cause)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyServiceStartupFailure(CamelContext context, Object service, Throwable cause) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreServiceEvents()) continue;
            if (event == null && (event = factory2.createServiceStartupFailureEvent(context, service, cause)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteStarting(CamelContext context, Route route) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory2.createRouteStartingEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteStarted(CamelContext context, Route route) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory2.createRouteStartedEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteStopping(CamelContext context, Route route) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory2.createRouteStoppingEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteStopped(CamelContext context, Route route) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory2.createRouteStoppedEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteAdded(CamelContext context, Route route) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory2.createRouteAddedEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteRemoved(CamelContext context, Route route) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory2.createRouteRemovedEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeCreated(CamelContext context, Exchange exchange) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeCreatedEvent()) continue;
            if (event == null && (event = factory2.createExchangeCreatedEvent(exchange)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeDone(CamelContext context, Exchange exchange) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeCompletedEvent()) continue;
            if (event == null && (event = factory2.createExchangeCompletedEvent(exchange)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeFailed(CamelContext context, Exchange exchange) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            if (event == null && (event = factory2.createExchangeFailedEvent(exchange)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeFailureHandling(CamelContext context, Exchange exchange, Processor failureHandler, boolean deadLetterChannel, String deadLetterUri) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            if (event == null && (event = factory2.createExchangeFailureHandlingEvent(exchange, failureHandler, deadLetterChannel, deadLetterUri)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeFailureHandled(CamelContext context, Exchange exchange, Processor failureHandler, boolean deadLetterChannel, String deadLetterUri) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            if (event == null && (event = factory2.createExchangeFailureHandledEvent(exchange, failureHandler, deadLetterChannel, deadLetterUri)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeRedelivery(CamelContext context, Exchange exchange, int attempt) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            if (event == null && (event = factory2.createExchangeRedeliveryEvent(exchange, attempt)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeSending(CamelContext context, Exchange exchange, Endpoint endpoint) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeSendingEvents()) continue;
            if (event == null && (event = factory2.createExchangeSendingEvent(exchange, endpoint)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeSent(CamelContext context, Exchange exchange, Endpoint endpoint, long timeTaken) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeSentEvents()) continue;
            if (event == null && (event = factory2.createExchangeSentEvent(exchange, endpoint, timeTaken)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextSuspending(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory2.createCamelContextSuspendingEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextSuspended(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory2.createCamelContextSuspendedEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextResuming(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory2.createCamelContextResumingEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextResumed(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory2.createCamelContextResumedEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextResumeFailed(CamelContext context, Throwable cause) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory2.createCamelContextResumeFailureEvent(context, cause)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextRoutesStarting(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory2.createCamelContextRoutesStartingEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextRoutesStarted(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory2.createCamelContextRoutesStartedEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextRoutesStopping(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory2.createCamelContextRoutesStoppingEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextRoutesStopped(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory2.createCamelContextRoutesStoppedEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyStepStarted(CamelContext context, Exchange exchange, String stepId) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreStepEvents()) continue;
            if (event == null && (event = factory2.createStepStartedEvent(exchange, stepId)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyStepDone(CamelContext context, Exchange exchange, String stepId) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreStepEvents()) continue;
            if (event == null && (event = factory2.createStepCompletedEvent(exchange, stepId)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyStepFailed(CamelContext context, Exchange exchange, String stepId) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory2 = management.getEventFactory();
        if (factory2 == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreStepEvents()) continue;
            if (event == null && (event = factory2.createStepFailedEvent(exchange, stepId)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    private static boolean doNotifyEvent(EventNotifier notifier, CamelEvent event) {
        boolean started = true;
        if (notifier instanceof StatefulService) {
            started = ((StatefulService)((Object)notifier)).isStarted();
        }
        if (!started) {
            LOG.debug("Ignoring notifying event {}. The EventNotifier has not been started yet: {}", (Object)event, (Object)notifier);
            return false;
        }
        if (!notifier.isEnabled(event)) {
            LOG.trace("Notifier: {} is not enabled for the event: {}", (Object)notifier, (Object)event);
            return false;
        }
        try {
            notifier.notify(event);
        }
        catch (Throwable e) {
            LOG.warn("Error notifying event " + event + ". This exception will be ignored.", e);
        }
        return true;
    }
}

