/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Ordered;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.util.Scanner;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ObjectHelper {
    private static final Pattern DEFAULT_PATTERN = Pattern.compile(",(?!(?:[^\\(,]|[^\\)],[^\\)])+\\))");
    private static final String DEFAULT_DELIMITER = ",";

    private ObjectHelper() {
    }

    public static boolean typeCoerceEquals(TypeConverter converter, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceEquals(converter, leftValue, rightValue, false);
    }

    public static boolean typeCoerceEquals(TypeConverter converter, Object leftValue, Object rightValue, boolean ignoreCase) {
        if (leftValue == null && rightValue == null) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        if (leftValue instanceof String && rightValue instanceof String) {
            String leftNum = (String)leftValue;
            String rightNum = (String)rightValue;
            if (ObjectHelper.isNumber(leftNum) && ObjectHelper.isNumber(rightNum)) {
                Long num2;
                Long num1 = Long.parseLong(leftNum);
                return num1.compareTo(num2 = Long.valueOf(Long.parseLong(rightNum))) == 0;
            }
            if (ignoreCase) {
                return leftNum.compareToIgnoreCase(rightNum) == 0;
            }
            return leftNum.compareTo(rightNum) == 0;
        }
        if (leftValue instanceof Integer && rightValue instanceof Integer) {
            Integer leftNum = (Integer)leftValue;
            Integer rightNum = (Integer)rightValue;
            return leftNum.compareTo(rightNum) == 0;
        }
        if (leftValue instanceof Long && rightValue instanceof Long) {
            Long leftNum = (Long)leftValue;
            Long rightNum = (Long)rightValue;
            return leftNum.compareTo(rightNum) == 0;
        }
        if (leftValue instanceof Double && rightValue instanceof Double) {
            Double leftNum = (Double)leftValue;
            Double rightNum = (Double)rightValue;
            return leftNum.compareTo(rightNum) == 0;
        }
        if ((rightValue instanceof Integer || rightValue instanceof Long) && leftValue instanceof String && ObjectHelper.isNumber((String)leftValue)) {
            Long rightNum;
            if (rightValue instanceof Integer) {
                Integer rightNum2;
                Integer leftNum = Integer.valueOf((String)leftValue);
                return leftNum.compareTo(rightNum2 = (Integer)rightValue) == 0;
            }
            Long leftNum = Long.valueOf((String)leftValue);
            return leftNum.compareTo(rightNum = (Long)rightValue) == 0;
        }
        if (rightValue instanceof String && (leftValue instanceof Integer || leftValue instanceof Long)) {
            if (leftValue instanceof Integer) {
                Integer leftNum = (Integer)leftValue;
                Integer rightNum = Integer.valueOf((String)rightValue);
                return leftNum.compareTo(rightNum) == 0;
            }
            Long leftNum = (Long)leftValue;
            Long rightNum = Long.valueOf((String)rightValue);
            return leftNum.compareTo(rightNum) == 0;
        }
        if (rightValue instanceof Double && leftValue instanceof String && ObjectHelper.isFloatingNumber((String)leftValue)) {
            Double rightNum;
            Double leftNum = Double.valueOf((String)leftValue);
            return leftNum.compareTo(rightNum = (Double)rightValue) == 0;
        }
        if (rightValue instanceof Boolean && leftValue instanceof String) {
            Boolean rightBool;
            Boolean leftBool = Boolean.valueOf((String)leftValue);
            return leftBool.compareTo(rightBool = (Boolean)rightValue) == 0;
        }
        if (rightValue instanceof String && leftValue instanceof Boolean) {
            Boolean leftBool = (Boolean)leftValue;
            Boolean rightBool = Boolean.valueOf((String)rightValue);
            return leftBool.compareTo(rightBool) == 0;
        }
        boolean answer = org.apache.camel.util.ObjectHelper.equal(leftValue, rightValue, ignoreCase);
        if (answer) {
            return true;
        }
        if (leftValue.getClass().isInstance(rightValue)) {
            return false;
        }
        Object value = converter.tryConvertTo(rightValue.getClass(), leftValue);
        answer = org.apache.camel.util.ObjectHelper.equal(value, rightValue, ignoreCase);
        if (answer) {
            return true;
        }
        value = converter.tryConvertTo(leftValue.getClass(), rightValue);
        answer = org.apache.camel.util.ObjectHelper.equal(leftValue, value, ignoreCase);
        return answer;
    }

    public static boolean typeCoerceNotEquals(TypeConverter converter, Object leftValue, Object rightValue) {
        return !ObjectHelper.typeCoerceEquals(converter, leftValue, rightValue);
    }

    public static int typeCoerceCompare(TypeConverter converter, Object leftValue, Object rightValue) {
        Object value;
        if (leftValue instanceof String && rightValue instanceof String) {
            String leftNum = (String)leftValue;
            String rightNum = (String)rightValue;
            if (ObjectHelper.isNumber(leftNum) && ObjectHelper.isNumber(rightNum)) {
                Long num1 = Long.parseLong(leftNum);
                Long num2 = Long.parseLong(rightNum);
                return num1.compareTo(num2);
            }
            return leftNum.compareTo(rightNum);
        }
        if (leftValue instanceof Integer && rightValue instanceof Integer) {
            Integer leftNum = (Integer)leftValue;
            Integer rightNum = (Integer)rightValue;
            return leftNum.compareTo(rightNum);
        }
        if (leftValue instanceof Long && rightValue instanceof Long) {
            Long leftNum = (Long)leftValue;
            Long rightNum = (Long)rightValue;
            return leftNum.compareTo(rightNum);
        }
        if (leftValue instanceof Double && rightValue instanceof Double) {
            Double leftNum = (Double)leftValue;
            Double rightNum = (Double)rightValue;
            return leftNum.compareTo(rightNum);
        }
        if ((rightValue instanceof Integer || rightValue instanceof Long) && leftValue instanceof String && ObjectHelper.isNumber((String)leftValue)) {
            if (rightValue instanceof Integer) {
                Integer leftNum = Integer.valueOf((String)leftValue);
                Integer rightNum = (Integer)rightValue;
                return leftNum.compareTo(rightNum);
            }
            Long leftNum = Long.valueOf((String)leftValue);
            Long rightNum = (Long)rightValue;
            return leftNum.compareTo(rightNum);
        }
        if (rightValue instanceof String && (leftValue instanceof Integer || leftValue instanceof Long)) {
            if (leftValue instanceof Integer) {
                Integer leftNum = (Integer)leftValue;
                Integer rightNum = Integer.valueOf((String)rightValue);
                return leftNum.compareTo(rightNum);
            }
            Long leftNum = (Long)leftValue;
            Long rightNum = Long.valueOf((String)rightValue);
            return leftNum.compareTo(rightNum);
        }
        if (rightValue instanceof Double && leftValue instanceof String && ObjectHelper.isFloatingNumber((String)leftValue)) {
            Double leftNum = Double.valueOf((String)leftValue);
            Double rightNum = (Double)rightValue;
            return leftNum.compareTo(rightNum);
        }
        if (rightValue instanceof Boolean && leftValue instanceof String) {
            Boolean leftBool = Boolean.valueOf((String)leftValue);
            Boolean rightBool = (Boolean)rightValue;
            return leftBool.compareTo(rightBool);
        }
        if (rightValue instanceof String && leftValue instanceof Boolean) {
            Boolean leftBool = (Boolean)leftValue;
            Boolean rightBool = Boolean.valueOf((String)rightValue);
            return leftBool.compareTo(rightBool);
        }
        Long leftNum = converter.tryConvertTo(Long.class, leftValue);
        Long rightNum = converter.tryConvertTo(Long.class, rightValue);
        if (leftNum != null && rightNum != null) {
            return leftNum.compareTo(rightNum);
        }
        Double leftDouble = converter.tryConvertTo(Double.class, leftValue);
        Double rightDouble = converter.tryConvertTo(Double.class, rightValue);
        if (leftDouble != null && rightDouble != null) {
            return leftDouble.compareTo(rightDouble);
        }
        if (rightValue instanceof String && !(leftValue instanceof String)) {
            return ObjectHelper.typeCoerceCompare(converter, rightValue, leftValue) * -1;
        }
        if (rightValue instanceof Comparable && (value = converter.tryConvertTo(rightValue.getClass(), leftValue)) != null) {
            return ((Comparable)rightValue).compareTo(value) * -1;
        }
        if (leftValue instanceof Comparable && (value = converter.tryConvertTo(leftValue.getClass(), rightValue)) != null) {
            return ((Comparable)leftValue).compareTo(value);
        }
        return ObjectHelper.compare(leftValue, rightValue);
    }

    public static boolean isNumber(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (i == 0 && ch == '-' || Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFloatingNumber(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        boolean dots = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (i == 0 && ch == '-') continue;
            if (ch == '.') {
                if (dots) {
                    return false;
                }
                dots = true;
                continue;
            }
            if (Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static Object invokeMethod(Method method, Object instance, Object ... parameters) {
        try {
            if (parameters != null) {
                return method.invoke(instance, parameters);
            }
            return method.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeCamelException(e);
        }
        catch (InvocationTargetException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e.getCause());
        }
    }

    public static Object invokeMethodSafe(Method method, Object instance, Object ... parameters) throws InvocationTargetException, IllegalAccessException {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        Object answer = parameters != null ? method.invoke(instance, parameters) : method.invoke(instance, new Object[0]);
        return answer;
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    public static <T> T newInstance(Class<?> actualType, Class<T> expectedType) {
        try {
            Object value = actualType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return org.apache.camel.util.ObjectHelper.cast(expectedType, value);
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    public static int compare(Object a, Object b) {
        return ObjectHelper.compare(a, b, false);
    }

    public static int compare(Object a, Object b, boolean ignoreCase) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Ordered && b instanceof Ordered) {
            return ((Ordered)a).getOrder() - ((Ordered)b).getOrder();
        }
        if (ignoreCase && a instanceof String && b instanceof String) {
            return ((String)a).compareToIgnoreCase((String)b);
        }
        if (a instanceof Comparable) {
            Comparable comparable = (Comparable)a;
            return comparable.compareTo(b);
        }
        int answer = a.getClass().getName().compareTo(b.getClass().getName());
        if (answer == 0) {
            answer = a.hashCode() - b.hashCode();
        }
        return answer;
    }

    public static Object callWithTCCL(Callable<?> call, Exchange exchange) throws Exception {
        ClassLoader apcl = null;
        if (exchange != null && exchange.getContext() != null) {
            apcl = exchange.getContext().getApplicationContextClassLoader();
        }
        return ObjectHelper.callWithTCCL(call, apcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callWithTCCL(Callable<?> call, ClassLoader classloader) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (classloader != null) {
                Thread.currentThread().setContextClassLoader(classloader);
            }
            Object obj = call.call();
            return obj;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public static Iterable<?> createIterable(Object value) {
        return ObjectHelper.createIterable(value, DEFAULT_DELIMITER);
    }

    public static Iterable<?> createIterable(Object value, String delimiter) {
        return ObjectHelper.createIterable(value, delimiter, false);
    }

    public static Iterable<String> createIterable(String value) {
        return ObjectHelper.createIterable(value, DEFAULT_DELIMITER);
    }

    public static Iterable<String> createIterable(String value, String delimiter) {
        return ObjectHelper.createIterable(value, delimiter, false);
    }

    public static Iterable<String> createIterable(String value, String delimiter, boolean allowEmptyValues) {
        return ObjectHelper.createIterable(value, delimiter, allowEmptyValues, false);
    }

    public static Iterable<String> createIterable(String value, String delimiter, boolean allowEmptyValues, boolean pattern) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (delimiter != null && (pattern || value.contains(delimiter))) {
            if (DEFAULT_DELIMITER.equals(delimiter)) {
                return () -> new Scanner(value, DEFAULT_PATTERN);
            }
            return () -> new Scanner(value, delimiter);
        }
        if (allowEmptyValues || org.apache.camel.util.ObjectHelper.isNotEmpty(value)) {
            return Collections.singletonList(value);
        }
        return Collections.emptyList();
    }

    public static Iterator<?> createIterator(Object value) {
        return ObjectHelper.createIterator(value, DEFAULT_DELIMITER);
    }

    public static Iterator<?> createIterator(Object value, String delimiter) {
        return ObjectHelper.createIterator(value, delimiter, false);
    }

    public static Iterator<?> createIterator(Object value, String delimiter, boolean allowEmptyValues) {
        if (value instanceof Stream) {
            return ((Stream)value).iterator();
        }
        return ObjectHelper.createIterable(value, delimiter, allowEmptyValues, false).iterator();
    }

    public static Iterator<?> createIterator(Object value, String delimiter, boolean allowEmptyValues, boolean pattern) {
        if (value instanceof Stream) {
            return ((Stream)value).iterator();
        }
        return ObjectHelper.createIterable(value, delimiter, allowEmptyValues, pattern).iterator();
    }

    public static Iterable<?> createIterable(Object value, String delimiter, boolean allowEmptyValues) {
        return ObjectHelper.createIterable(value, delimiter, allowEmptyValues, false);
    }

    public static Iterable<?> createIterable(Object value, String delimiter, final boolean allowEmptyValues, boolean pattern) {
        if (value instanceof Message) {
            value = ((Message)value).getBody();
        }
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Iterator) {
            final Iterator iterator2 = (Iterator)value;
            return new Iterable<Object>(){

                @Override
                public Iterator<Object> iterator() {
                    return iterator2;
                }
            };
        }
        if (value instanceof Iterable) {
            return (Iterable)value;
        }
        if (value.getClass().isArray()) {
            if (org.apache.camel.util.ObjectHelper.isPrimitiveArrayType(value.getClass())) {
                final Object array = value;
                return () -> new Iterator<Object>(){
                    private int idx;

                    @Override
                    public boolean hasNext() {
                        return this.idx < Array.getLength(array);
                    }

                    @Override
                    public Object next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException("no more element available for '" + array + "' at the index " + this.idx);
                        }
                        return Array.get(array, this.idx++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            return Arrays.asList((Object[])value);
        }
        if (value instanceof NodeList) {
            final NodeList nodeList = (NodeList)value;
            return () -> new Iterator<Node>(){
                private int idx;

                @Override
                public boolean hasNext() {
                    return this.idx < nodeList.getLength();
                }

                @Override
                public Node next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("no more element available for '" + nodeList + "' at the index " + this.idx);
                    }
                    return nodeList.item(this.idx++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (value instanceof String) {
            final String s = (String)value;
            if (delimiter != null && (pattern || s.contains(delimiter))) {
                if (DEFAULT_DELIMITER.equals(delimiter)) {
                    return () -> new Scanner(s, DEFAULT_PATTERN);
                }
                return () -> new Scanner(s, delimiter);
            }
            return () -> new Iterator<Object>(){
                private int idx;

                @Override
                public boolean hasNext() {
                    return this.idx == 0 && (allowEmptyValues || org.apache.camel.util.ObjectHelper.isNotEmpty(s));
                }

                @Override
                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("no more element available for '" + s + "' at the index " + this.idx);
                    }
                    ++this.idx;
                    return s;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return Collections.singletonList(value);
    }

    @Deprecated
    public static boolean contains(Object collectionOrArray, Object value) {
        if (collectionOrArray != null && (collectionOrArray instanceof StringBuffer || collectionOrArray instanceof StringBuilder)) {
            collectionOrArray = collectionOrArray.toString();
        }
        if (value != null && (value instanceof StringBuffer || value instanceof StringBuilder)) {
            value = value.toString();
        }
        if (collectionOrArray instanceof Collection) {
            Collection collection = (Collection)collectionOrArray;
            return collection.contains(value);
        }
        if (collectionOrArray instanceof String && value instanceof String) {
            String str = (String)collectionOrArray;
            String subStr = (String)value;
            return str.contains(subStr);
        }
        Iterator<?> iter = ObjectHelper.createIterator(collectionOrArray);
        while (iter.hasNext()) {
            if (!org.apache.camel.util.ObjectHelper.equal(value, iter.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean typeCoerceContains(TypeConverter typeConverter, Object collectionOrArray, Object value, boolean ignoreCase) {
        if (collectionOrArray != null && (collectionOrArray instanceof StringBuffer || collectionOrArray instanceof StringBuilder)) {
            collectionOrArray = collectionOrArray.toString();
        }
        if (value instanceof StringBuffer || value instanceof StringBuilder) {
            value = value.toString();
        }
        if (collectionOrArray instanceof Collection) {
            Collection collection = (Collection)collectionOrArray;
            if (ignoreCase) {
                String lower = value.toString().toLowerCase(Locale.ENGLISH);
                return collection.stream().anyMatch(c -> c.toString().toLowerCase(Locale.ENGLISH).contains(lower));
            }
            return collection.contains(value);
        }
        if (collectionOrArray instanceof String) {
            String str = (String)collectionOrArray;
            String subStr = value instanceof String ? (String)value : typeConverter.tryConvertTo(String.class, value);
            if (subStr != null) {
                if (ignoreCase) {
                    String lower = subStr.toLowerCase(Locale.ENGLISH);
                    return str.toLowerCase(Locale.ENGLISH).contains(lower);
                }
                return str.contains(subStr);
            }
        }
        Iterator<?> iter = ObjectHelper.createIterator(collectionOrArray);
        while (iter.hasNext()) {
            if (!ObjectHelper.typeCoerceEquals(typeConverter, value, iter.next(), ignoreCase)) continue;
            return true;
        }
        return false;
    }
}

