/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jsmpp.DefaultPDUReader;
import org.jsmpp.DefaultPDUSender;
import org.jsmpp.InvalidCommandLengthException;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.PDUReader;
import org.jsmpp.PDUSender;
import org.jsmpp.PDUStringException;
import org.jsmpp.SynchronizedPDUSender;
import org.jsmpp.bean.Bind;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.CancelSm;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.MessageState;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.QuerySm;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceSm;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.SubmitMultiResult;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSession;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.BindRequestReceiver;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.DeliverSmCommandTask;
import org.jsmpp.session.GenericMessageReceiverListener;
import org.jsmpp.session.PDUProcessServerTask;
import org.jsmpp.session.QuerySmResult;
import org.jsmpp.session.SMPPServerSessionContext;
import org.jsmpp.session.ServerMessageReceiverListener;
import org.jsmpp.session.ServerResponseDeliveryListener;
import org.jsmpp.session.ServerResponseHandler;
import org.jsmpp.session.ServerSession;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.connection.Connection;
import org.jsmpp.util.MessageId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPPServerSession
extends AbstractSession
implements ServerSession {
    private static final Logger logger = LoggerFactory.getLogger(SMPPServerSession.class);
    private final Connection conn;
    private final DataInputStream in;
    private final OutputStream out;
    private final PDUReader pduReader;
    private SMPPServerSessionContext sessionContext = new SMPPServerSessionContext(this);
    private final ServerResponseHandler responseHandler = new ResponseHandlerImpl();
    private ServerMessageReceiverListener messageReceiverListener;
    private ServerResponseDeliveryListener responseDeliveryListener;
    private final EnquireLinkSender enquireLinkSender;
    private BindRequestReceiver bindRequestReceiver = new BindRequestReceiver(this.responseHandler);

    public SMPPServerSession(Connection conn, SessionStateListener sessionStateListener, ServerMessageReceiverListener messageReceiverListener, ServerResponseDeliveryListener responseDeliveryListener, int pduProcessorDegree) {
        this(conn, sessionStateListener, messageReceiverListener, responseDeliveryListener, pduProcessorDegree, new SynchronizedPDUSender(new DefaultPDUSender()), new DefaultPDUReader());
    }

    public SMPPServerSession(Connection conn, SessionStateListener sessionStateListener, ServerMessageReceiverListener messageReceiverListener, ServerResponseDeliveryListener responseDeliveryListener, int pduProcessorDegree, PDUSender pduSender, PDUReader pduReader) {
        super(pduSender);
        this.conn = conn;
        this.messageReceiverListener = messageReceiverListener;
        this.responseDeliveryListener = responseDeliveryListener;
        this.pduReader = pduReader;
        this.in = new DataInputStream(conn.getInputStream());
        this.out = conn.getOutputStream();
        this.enquireLinkSender = new EnquireLinkSender();
        this.addSessionStateListener(new BoundStateListener());
        this.addSessionStateListener(sessionStateListener);
        this.setPduProcessorDegree(pduProcessorDegree);
        this.sessionContext.open();
    }

    public BindRequest waitForBind(long timeout) throws IllegalStateException, TimeoutException {
        if (this.getSessionState().equals((Object)SessionState.OPEN)) {
            new PDUReaderWorker().start();
            try {
                return this.bindRequestReceiver.waitForRequest(timeout);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Invocation of waitForBind() has been made", e);
            }
            catch (TimeoutException e) {
                this.close();
                throw e;
            }
        }
        throw new IllegalStateException("waitForBind() should be invoked on OPEN state, actual state is " + (Object)((Object)SessionState.OPEN));
    }

    private synchronized boolean isReadPdu() {
        SessionState sessionState = this.sessionContext.getSessionState();
        return sessionState.isBound() || sessionState.equals((Object)SessionState.OPEN);
    }

    @Override
    public void deliverShortMessage(String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, byte protocoId, byte priorityFlag, RegisteredDelivery registeredDelivery, DataCoding dataCoding, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        DeliverSmCommandTask task = new DeliverSmCommandTask(this.pduSender(), serviceType, sourceAddrTon, sourceAddrNpi, sourceAddr, destAddrTon, destAddrNpi, destinationAddr, esmClass, protocoId, protocoId, registeredDelivery, dataCoding, shortMessage, optionalParameters);
        this.executeSendCommand(task, this.getTransactionTimer());
    }

    @Override
    public void alertNotification(int sequenceNumber, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber esmeAddrTon, NumberingPlanIndicator esmeAddrNpi, String esmeAddr, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        this.pduSender().sendAlertNotification(this.connection().getOutputStream(), sequenceNumber, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, esmeAddrTon.value(), esmeAddrNpi.value(), esmeAddr, optionalParameters);
    }

    private MessageId fireAcceptSubmitSm(SubmitSm submitSm) throws ProcessRequestException {
        if (this.messageReceiverListener != null) {
            return this.messageReceiverListener.onAcceptSubmitSm(submitSm, this);
        }
        throw new ProcessRequestException("MessageReceveiverListener hasn't been set yet", 102);
    }

    private SubmitMultiResult fireAcceptSubmitMulti(SubmitMulti submitMulti) throws ProcessRequestException {
        if (this.messageReceiverListener != null) {
            return this.messageReceiverListener.onAcceptSubmitMulti(submitMulti, this);
        }
        throw new ProcessRequestException("MessageReceveiverListener hasn't been set yet", 102);
    }

    private QuerySmResult fireAcceptQuerySm(QuerySm querySm) throws ProcessRequestException {
        if (this.messageReceiverListener != null) {
            return this.messageReceiverListener.onAcceptQuerySm(querySm, this);
        }
        throw new ProcessRequestException("MessageReceveiverListener hasn't been set yet", 102);
    }

    private void fireAcceptReplaceSm(ReplaceSm replaceSm) throws ProcessRequestException {
        if (this.messageReceiverListener == null) {
            throw new ProcessRequestException("MessageReceveiverListener hasn't been set yet", 102);
        }
        this.messageReceiverListener.onAcceptReplaceSm(replaceSm, this);
    }

    private void fireAcceptCancelSm(CancelSm cancelSm) throws ProcessRequestException {
        if (this.messageReceiverListener == null) {
            throw new ProcessRequestException("MessageReceveiverListener hasn't been set yet", 102);
        }
        this.messageReceiverListener.onAcceptCancelSm(cancelSm, this);
    }

    private void fireSubmitSmRespSent(MessageId messageId) {
        if (this.responseDeliveryListener != null) {
            this.responseDeliveryListener.onSubmitSmRespSent(messageId, this);
        }
    }

    private void fireSubmitSmRespFailed(MessageId messageId, Exception cause) {
        if (this.responseDeliveryListener != null) {
            this.responseDeliveryListener.onSubmitSmRespError(messageId, cause, this);
        }
    }

    private void fireSubmitMultiRespSent(SubmitMultiResult submitMultiResult) {
        if (this.responseDeliveryListener != null) {
            this.responseDeliveryListener.onSubmitMultiRespSent(submitMultiResult, this);
        }
    }

    private void fireSubmitMultiRespSentError(SubmitMultiResult submitMultiResult, Exception cause) {
        if (this.responseDeliveryListener != null) {
            this.responseDeliveryListener.onSubmitMultiRespError(submitMultiResult, cause, this);
        }
    }

    @Override
    protected Connection connection() {
        return this.conn;
    }

    @Override
    protected AbstractSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    protected GenericMessageReceiverListener messageReceiverListener() {
        return this.messageReceiverListener;
    }

    public ServerMessageReceiverListener getMessageReceiverListener() {
        return this.messageReceiverListener;
    }

    public void setMessageReceiverListener(ServerMessageReceiverListener messageReceiverListener) {
        this.messageReceiverListener = messageReceiverListener;
    }

    public void setResponseDeliveryListener(ServerResponseDeliveryListener responseDeliveryListener) {
        this.responseDeliveryListener = responseDeliveryListener;
    }

    private class BoundStateListener
    implements SessionStateListener {
        private BoundStateListener() {
        }

        @Override
        public void onStateChange(SessionState newState, SessionState oldState, Object source) {
            if (newState.isBound()) {
                SMPPServerSession.this.enquireLinkSender.start();
            }
        }
    }

    private class EnquireLinkSender
    extends Thread {
        private final AtomicBoolean sendingEnquireLink = new AtomicBoolean(false);

        private EnquireLinkSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.info("Starting EnquireLinkSender");
            while (SMPPServerSession.this.isReadPdu()) {
                while (!this.sendingEnquireLink.compareAndSet(true, false) && SMPPServerSession.this.isReadPdu()) {
                    AtomicBoolean atomicBoolean = this.sendingEnquireLink;
                    synchronized (atomicBoolean) {
                        try {
                            this.sendingEnquireLink.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (!SMPPServerSession.this.isReadPdu()) break;
                try {
                    SMPPServerSession.this.sendEnquireLink();
                }
                catch (ResponseTimeoutException e) {
                    SMPPServerSession.this.close();
                }
                catch (InvalidResponseException e) {
                    SMPPServerSession.this.unbindAndClose();
                }
                catch (IOException e) {
                    SMPPServerSession.this.close();
                }
            }
            logger.info("EnquireLinkSender stop");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enquireLink() {
            if (this.sendingEnquireLink.compareAndSet(false, true)) {
                AtomicBoolean atomicBoolean = this.sendingEnquireLink;
                synchronized (atomicBoolean) {
                    this.sendingEnquireLink.notify();
                }
            }
        }
    }

    private class PDUReaderWorker
    extends Thread {
        private ExecutorService executorService;
        private Runnable onIOExceptionTask;

        private PDUReaderWorker() {
            this.executorService = Executors.newFixedThreadPool(SMPPServerSession.this.getPduProcessorDegree());
            this.onIOExceptionTask = new Runnable(){

                @Override
                public void run() {
                    SMPPServerSession.this.close();
                }
            };
        }

        @Override
        public void run() {
            logger.info("Starting PDUReaderWorker with processor degree:{} ...", (Object)SMPPServerSession.this.getPduProcessorDegree());
            while (SMPPServerSession.this.isReadPdu()) {
                this.readPDU();
            }
            SMPPServerSession.this.close();
            this.executorService.shutdown();
            logger.info("PDUReaderWorker stop");
        }

        private void readPDU() {
            try {
                Command pduHeader = null;
                byte[] pdu = null;
                pduHeader = SMPPServerSession.this.pduReader.readPDUHeader(SMPPServerSession.this.in);
                pdu = SMPPServerSession.this.pduReader.readPDU(SMPPServerSession.this.in, pduHeader);
                PDUProcessServerTask task = new PDUProcessServerTask(pduHeader, pdu, SMPPServerSession.this.sessionContext.getStateProcessor(), SMPPServerSession.this.sessionContext, SMPPServerSession.this.responseHandler, this.onIOExceptionTask);
                this.executorService.execute(task);
            }
            catch (InvalidCommandLengthException e) {
                logger.warn("Receive invalid command length", (Throwable)e);
                try {
                    SMPPServerSession.this.pduSender().sendGenericNack(SMPPServerSession.this.out, 2, 0);
                }
                catch (IOException ee) {
                    logger.warn("Failed sending generic nack", (Throwable)ee);
                }
                SMPPServerSession.this.unbindAndClose();
            }
            catch (SocketTimeoutException e) {
                this.notifyNoActivity();
            }
            catch (IOException e) {
                SMPPServerSession.this.close();
            }
        }

        private void notifyNoActivity() {
            logger.debug("No activity notified");
            SMPPServerSession.this.enquireLinkSender.enquireLink();
        }
    }

    private class ResponseHandlerImpl
    implements ServerResponseHandler {
        private ResponseHandlerImpl() {
        }

        @Override
        public PendingResponse<Command> removeSentItem(int sequenceNumber) {
            return SMPPServerSession.this.removePendingResponse(sequenceNumber);
        }

        @Override
        public void notifyUnbonded() {
            SMPPServerSession.this.sessionContext.unbound();
        }

        @Override
        public void sendEnquireLinkResp(int sequenceNumber) throws IOException {
            logger.debug("Sending enquire_link_resp");
            SMPPServerSession.this.pduSender().sendEnquireLinkResp(SMPPServerSession.this.out, sequenceNumber);
        }

        @Override
        public void sendGenerickNack(int commandStatus, int sequenceNumber) throws IOException {
            SMPPServerSession.this.pduSender().sendGenericNack(SMPPServerSession.this.out, commandStatus, sequenceNumber);
        }

        @Override
        public void sendNegativeResponse(int originalCommandId, int commandStatus, int sequenceNumber) throws IOException {
            SMPPServerSession.this.pduSender().sendHeader(SMPPServerSession.this.out, originalCommandId | Integer.MIN_VALUE, commandStatus, sequenceNumber);
        }

        @Override
        public void sendUnbindResp(int sequenceNumber) throws IOException {
            SMPPServerSession.this.pduSender().sendUnbindResp(SMPPServerSession.this.out, 0, sequenceNumber);
        }

        @Override
        public void sendBindResp(String systemId, BindType bindType, int sequenceNumber) throws IOException {
            SMPPServerSession.this.sessionContext.bound(bindType);
            try {
                SMPPServerSession.this.pduSender().sendBindResp(SMPPServerSession.this.out, bindType.responseCommandId(), sequenceNumber, systemId);
            }
            catch (PDUStringException e) {
                logger.error("Failed sending bind response", (Throwable)e);
            }
        }

        @Override
        public void processBind(Bind bind) {
            SMPPServerSession.this.bindRequestReceiver.notifyAcceptBind(bind);
        }

        @Override
        public MessageId processSubmitSm(SubmitSm submitSm) throws ProcessRequestException {
            return SMPPServerSession.this.fireAcceptSubmitSm(submitSm);
        }

        @Override
        public void sendSubmitSmResponse(MessageId messageId, int sequenceNumber) throws IOException {
            try {
                SMPPServerSession.this.pduSender().sendSubmitSmResp(SMPPServerSession.this.out, sequenceNumber, messageId.getValue());
                SMPPServerSession.this.fireSubmitSmRespSent(messageId);
            }
            catch (PDUStringException e) {
                logger.error("SYSTEM ERROR. Failed sending submitSmResp", (Throwable)e);
                SMPPServerSession.this.fireSubmitSmRespFailed(messageId, e);
            }
            catch (IOException e) {
                SMPPServerSession.this.fireSubmitSmRespFailed(messageId, e);
                throw e;
            }
            catch (RuntimeException e) {
                SMPPServerSession.this.fireSubmitSmRespFailed(messageId, e);
                throw e;
            }
        }

        @Override
        public SubmitMultiResult processSubmitMulti(SubmitMulti submitMulti) throws ProcessRequestException {
            return SMPPServerSession.this.fireAcceptSubmitMulti(submitMulti);
        }

        @Override
        public void sendSubmitMultiResponse(SubmitMultiResult submitMultiResult, int sequenceNumber) throws IOException {
            try {
                SMPPServerSession.this.pduSender().sendSubmitMultiResp(SMPPServerSession.this.out, sequenceNumber, submitMultiResult.getMessageId(), submitMultiResult.getUnsuccessDeliveries());
                SMPPServerSession.this.fireSubmitMultiRespSent(submitMultiResult);
            }
            catch (PDUStringException e) {
                logger.error("SYSTEM ERROR. Failed sending submitMultiResp", (Throwable)e);
                SMPPServerSession.this.fireSubmitMultiRespSentError(submitMultiResult, e);
            }
            catch (IOException e) {
                SMPPServerSession.this.fireSubmitMultiRespSentError(submitMultiResult, e);
                throw e;
            }
            catch (RuntimeException e) {
                SMPPServerSession.this.fireSubmitMultiRespSentError(submitMultiResult, e);
                throw e;
            }
        }

        @Override
        public QuerySmResult processQuerySm(QuerySm querySm) throws ProcessRequestException {
            return SMPPServerSession.this.fireAcceptQuerySm(querySm);
        }

        @Override
        public void sendQuerySmResp(String messageId, String finalDate, MessageState messageState, byte errorCode, int sequenceNumber) throws IOException {
            try {
                SMPPServerSession.this.pduSender().sendQuerySmResp(SMPPServerSession.this.out, sequenceNumber, messageId, finalDate, messageState, errorCode);
            }
            catch (PDUStringException e) {
                logger.error("SYSTEM ERROR. Failed sending cancelSmResp", (Throwable)e);
            }
        }

        @Override
        public DataSmResult processDataSm(DataSm dataSm) throws ProcessRequestException {
            return SMPPServerSession.this.fireAcceptDataSm(dataSm);
        }

        @Override
        public void sendDataSmResp(DataSmResult dataSmResult, int sequenceNumber) throws IOException {
            try {
                SMPPServerSession.this.pduSender().sendDataSmResp(SMPPServerSession.this.out, sequenceNumber, dataSmResult.getMessageId(), dataSmResult.getOptionalParameters());
            }
            catch (PDUStringException e) {
                logger.error("SYSTEM ERROR. Failed sending dataSmResp", (Throwable)e);
            }
        }

        @Override
        public void processCancelSm(CancelSm cancelSm) throws ProcessRequestException {
            SMPPServerSession.this.fireAcceptCancelSm(cancelSm);
        }

        @Override
        public void sendCancelSmResp(int sequenceNumber) throws IOException {
            SMPPServerSession.this.pduSender().sendCancelSmResp(SMPPServerSession.this.out, sequenceNumber);
        }

        @Override
        public void processReplaceSm(ReplaceSm replaceSm) throws ProcessRequestException {
            SMPPServerSession.this.fireAcceptReplaceSm(replaceSm);
        }

        @Override
        public void sendReplaceSmResp(int sequenceNumber) throws IOException {
            SMPPServerSession.this.pduSender().sendReplaceSmResp(SMPPServerSession.this.out, sequenceNumber);
        }
    }
}

